---
name: clickbait-engine
description: Generate sensational, engagement-maximizing titles, hooks, and clip captions for social media posts, YouTube videos, and tweets. Use when creating titles, thumbnails copy, tweet hooks, clip captions, or any content that needs maximum click-through. Triggers on: clickbait, title, hook, caption, engagement, viral title, sensational, hot take.
---

# Clickbait Engine - Engagement-Maximized Content Titles & Hooks

Built from studying @AlexFinn (406K, $300K ARR), @notthreadguy (355K), and @Jackkk (29K, 37M impressions/2wks).

## The Three Masters: What They Do

### Alex Finn (@AlexFinn) - The Absolutist
**Pattern:** Extreme declarative statements that force agreement or outrage.
- "Apple will win the AI war in June 2026 without investing a single penny into AI"
- "OpenClaw is the greatest application of AI we've ever seen"
- "Humanity has advanced more in the past 3 weeks than the previous 100 years combined"
- "We have entered a new age"
- "It's never been more important to move as violently as possible"

**Why it works:**
- **Superlatives force reaction** — "greatest," "never been more," "ever" — you HAVE to click to see if he's right
- **Time compression** — "3 weeks > 100 years" creates cognitive dissonance
- **Identity statements** — "We have entered a new age" makes you feel like you're missing something
- **Zero hedging** — no "I think" or "maybe" — pure conviction = engagement

### ThreadGuy (@notthreadguy) - The Unfiltered Reactor
**Pattern:** Raw emotional reactions that mirror what the audience is thinking but won't say.
- "theyre trying to convince sbf to claim bags app fees LMFAOOOOOOOOOOO"
- "i'm legitimately tired bro"
- "why is sam bankman fried on my timeline every morning please make it stop"
- "if you ever tell me to go to sleep again i will start using chatgpt"
- "need a term to differentiate actually reading something vs having ai summarize it"
- "in the club thinking about Dario Amodei"

**Why it works:**
- **Parasocial intimacy** — talks like he's texting his group chat, not broadcasting
- **Lowercase = authenticity** — no caps, no polish = "real" feels
- **Cultural references as punchlines** — drops names (SBF, Dario) without context = insiders club
- **Creates vocabulary** — "read it raw" → meme-able, shareable, screenshot-able
- **Absurdist juxtaposition** — "in the club thinking about Dario Amodei" = unexpected + relatable

### Jackkk (@Jackkk) - The Quote Clipper
**Pattern:** Extract the most provocative quote from a conversation, frame it as a reveal.
- "MrBeast reveals he doesn't like expensive food"
- "Threadguy reveals Nick Fuentes has a Milady alt account"
- "Top geopolitical trader reveals intelligence agencies are looking at Polymarket"
- "TJR reveals his $3,500,000 Koenigsegg did NOT get repossessed"

**Why it works:**
- **"reveals" = instant curiosity gap** — implies secret knowledge being shared
- **Name + shocking statement** — borrowed authority + unexpected claim
- **Dollar amounts** — $3.5M, $100K/y — concrete numbers trigger clicking
- **Contradiction framing** — "did NOT get repossessed" — correcting a narrative = drama

## The Behavioral Science

### 1. Curiosity Gap (Loewenstein, 1994)
Create a gap between what people know and what they WANT to know. Never close it in the title.
- ❌ "Here's why Apple will win the AI war: they have M5 chips"
- ✅ "Apple will win the AI war without investing a single penny into AI"

### 2. Loss Aversion (Kahneman & Tversky)
Humans fear missing out 2x more than they enjoy gaining. Frame titles as "you're behind."
- "Stop what you're doing" (implies urgency, you're wasting time)
- "We have entered a new age" (if you didn't know, you're behind)
- "How do you not see this future?" (you're blind if you disagree)

### 3. Social Proof + Authority
Name-drop people with status. The audience clicks to see what the authority said.
- "MrBeast reveals..."
- "Michael Burry is short stocks and he's wrong"
- Frame experts as "top [role]" even if vague

### 4. Pattern Interrupt
Break expected formatting to stop the scroll.
- ALL CAPS for emphasis: "LMFAOOOOOOOOOOO"
- Extended letters: "please make it stopppp"
- Single-word reactions: "what" (with quote tweet)
- Absurdist mismatch: "in the club thinking about Dario Amodei"

### 5. Tribal Identity
Make the reader feel they're part of an in-group or challenge their membership.
- "if you ever tell me to go to sleep again i will start using chatgpt" (claude users = tribe)
- "everybody fc bitcoin right now" (community command)
- "The world has changed more in the past month than the previous decade" (if you don't feel this, you're out)

## Title Formulas (Pick and Apply)

### The Absolutist (Alex Finn style)
```
[Subject] is the [superlative] [thing] [timeframe qualifier]
[Subject] will [bold prediction] without [expected requirement]
[Timeframe] has [changed/advanced] more than [longer timeframe]
It's never been more [important/urgent] to [action]
```

### The Reveal (Jackkk style)
```
[Person] reveals [unexpected fact about topic]
[Person] explains why [counterintuitive claim]
[Role] reveals [insider knowledge] about [trending topic]
[Person]'s $[big number] [thing] [unexpected outcome]
```

### The Reactor (ThreadGuy style)
```
[lowercase raw reaction to trending event]
[absurdist observation] + [unexpected cultural reference]
need a [new concept] for [common experience everyone relates to]
[person/thing] on my timeline [emotional reaction] please [dramatic request]
```

### The Hot Take (General)
```
[Common belief] is wrong. Here's why.
Everyone is [doing X]. Nobody is [doing Y].
[Controversial figure] was right about [topic nobody wants to admit]
The real reason [thing happened] has nothing to do with [obvious cause]
```

### The Medieval Mindset (Video Essay style)
```
Why [Modern Trend] Is Basically [Historical Parallel]
[Gen Z Thing] Has Ancient Roots Nobody Talks About
The [Adjective] History Behind [Viral Trend]
[Current Culture] = [Unexpected Historical Era] (Here's Proof)
```

## Clip Caption Formulas (For Posting Clips to X)

### The Setup → Punchline
```
[context of the game/scene]
[the rules in > arrows]
[what happened — the unexpected moment]
powered by [tag]
```

### The Quote Pull
```
"[most provocative direct quote from clip]"
[one-line context]
[tag]
```

### The Reaction Bait
```
[short description of what's about to happen]
nobody was ready for this
[tag]
```

## Honey B / Other Games Application

For Otherside content specifically:
1. **Frame events as cultural moments**, not just games — "speed dating on the Otherside" not "our emote matching game"
2. **Name-drop participating projects** — borrowed authority from WoW, BAYC, etc.
3. **Use game mechanics as hooks** — "if they don't match they're incompatible → kicked out the bar" = drama
4. **Lowercase authenticity** for tweet text, CAPS only for emphasis moments
5. **Every clip needs a one-line setup** that creates curiosity before the viewer hits play

### The Lore Clipper (Clavicular/KickChamp/Clippd style)
The hottest format right now. Treats real life like an RPG/anime saga.
```
[Character] was CAUGHT [embarrassing action] right after ASCENDING to #[rank] on the [Leaderboard] which could trigger an instant [DEBUFF] and push him back to #[rank] making the [RIVAL] reclaim #1
```
```
[Height] [Nationality] [TIER]-CHAD [Name] has [DRAMATIC ACTION] in order to [QUEST OBJECTIVE] and engage in a [COMPETITION TYPE] to avenge [ALLY] after the BRUTAL [incident] last [timeframe]
```

**Key rules:**
- Headlines have NOTHING to do with the actual video (the lingo IS the product)
- Use RPG/gaming language: debuffs, ascending, leaderboards, mog, saga
- Frame everything as an ongoing SAGA with characters and rivalries
- ALL CAPS for power words: CAUGHT, BRUTAL, ASCENDING, HUNT, REJECTED
- Treat streamers/participants like anime characters with arcs
- Works because Gen Z already thinks in gaming terms (Medieval China article confirms this)

**Lingo dictionary:**
- Mogging = physically/socially dominating someone
- Frame mog = dominating with physical frame/size
- Ascending = improving your ranking/status
- Debuff = negative event reducing your score
- Looksmaxxing = enhancing appearance at any cost
- TERA-CHAD = ultimate tier alpha
- Jester maxing = compensating with humor
- Burgergooning = eating junk (seen as failure)

**Why it works (behavioral science):**
- Serialized narrative creates investment (soap opera effect)
- RPG language gamifies real life (engagement through familiar framework)
- CAPS + dramatic framing triggers pattern interrupt
- "Saga" framing makes people want to follow the whole arc, not just one clip
- @beffjezos: "This saga is better than the Marvel franchises at this point"

**Application to Other Games / Otherside clips:**
- Frame events as ongoing sagas with characters
- Kodas become recurring characters with arcs
- Event outcomes = plot twists
- Use RPG language naturally (we're literally in a game world)

## Anti-Patterns (What Kills Engagement)
- ❌ Hedging: "I think maybe this could be..."
- ❌ Corporate voice: "We're excited to announce..."
- ❌ Explaining in the title what the content shows (kills curiosity gap)
- ❌ Generic superlatives without specificity: "This is amazing!"
- ❌ Too many hashtags (looks desperate)
- ❌ Emojis (Honey B's rule — and it reads cleaner)
- ❌ Em dashes (AI tell)

## When Used by Cello
1. Always generate 3-5 title options, ranked by engagement potential
2. Score each on: Curiosity Gap (1-5), Emotional Trigger (1-5), Shareability (1-5)
3. Default to the one with highest combined score
4. For clips: use Setup → Punchline format unless quote is more powerful
5. All @handles must be verified before posting (reference/verified-handles.md)
