# Clear Writing

Write clear, concise prose for humans — documentation, READMEs, API docs, commit messages, error messages, UI text, reports, and explanations. Combines Strunk's rules for clearer prose with technical documentation patterns, structure templates, and review checklists.

## What's Inside

- Elements of Style rules (grammar, punctuation, composition principles)
- AI writing anti-patterns to avoid (puffery, empty phrases, overused vocabulary)
- Document types using the Divio Framework (README, Tutorial, How-to, Reference, Explanation, Architecture, API)
- Structure patterns (Inverted Pyramid, Problem-Solution, Sequential Steps)
- Writing rules table (short sentences, active voice, present tense, concrete language)
- Code examples in documentation guidelines
- README and API documentation templates
- Audience adaptation (beginner, intermediate, expert)
- Review checklist and documentation anti-patterns
- Reference files for Strunk's Elements of Style chapters

## When to Use

- Writing documentation, README files, technical explanations
- API documentation, endpoint references, integration guides
- Tutorials, how-to guides, architecture docs
- Commit messages, pull request descriptions
- Error messages, UI copy, help text, comments
- Reports, summaries, or any explanation
- Editing existing prose to improve clarity

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/writing/clear-writing
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install clear-writing
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/writing/clear-writing .cursor/skills/clear-writing
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/writing/clear-writing ~/.cursor/skills/clear-writing
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/writing/clear-writing .claude/skills/clear-writing
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/writing/clear-writing ~/.claude/skills/clear-writing
```

## Related Skills

- **professional-communication** — For emails, Slack messages, and meeting agendas
- **prompt-engineering** — For writing effective LLM prompts

---

Part of the [Writing](..) skill category.
