# Looksmaxxing Slang Dictionary

300+ terms organized by category. Each entry has a definition and example sentence in community voice.

---

## -Maxxing Terms

### looksmaxxing
Improving your physical appearance through any means — skincare, gym, surgery, mewing, style, etc. The umbrella term for the whole movement.
> "been looksmaxxing for 6 months and my jawline is finally showing up to work"

### softmaxxing
Non-invasive improvements — skincare, haircut, style, gym, grooming. The stuff you can do without a surgeon.
> "bro said he's softmaxxing but all he did was buy a new hoodie 💀"

### hardmaxxing
Surgical or extreme physical modifications — rhinoplasty, jaw implants, under-eye filler, etc.
> "he went from a 4 to an 8 but it cost him $30k in hardmaxxing procedures"

### statusmaxxing
Improving your perceived social status — career, wealth, social circle, clout.
> "forget mewing bro needs to be statusmaxxing that resume"

### gymmaxxing
Maximizing your physique through lifting, diet, and training.
> "he's been gymmaxxing for a year and still skips legs. tragic."

### fraudmaxxing
Using deceptive techniques to appear better looking — angles, filters, lighting, lifts in shoes, etc.
> "that dating profile is pure fraudmaxxing. he's 5'7 in real life"

### moneymaxxing
Focused on maximizing income and wealth as a path to attractiveness.
> "why mew when you can moneymaxx your way to the top"

### careermaxxing
Maximizing your career progression, often overlapping with statusmaxxing.
> "bro is careermaxxing at 19, gonna be a mogger CEO by 25"

### heightmaxxing
Trying to maximize height through stretching, posture, limb lengthening, or just coping.
> "he bought those height insoles thinking nobody would notice. heightmaxxing gone wrong"

### stylemaxxing
Improving your fashion and personal style.
> "a good stylemaxx can take you from a 5 to a 7 without touching your face"

### skinmaxxing
Dedicated skincare routine to improve skin quality.
> "tretinoin, sunscreen, moisturizer every day. the skinmaxx is paying off"

### surgerymaxxing
Going all-in on cosmetic surgery to ascend.
> "bro surgerymaxxed his whole face. new chin, new nose, new man"

### bonesmashing
Repeatedly hitting your face with a blunt object (like a bottle) to supposedly stimulate bone growth. Extremely controversial.
> "he said bonesmashing gave him a better jawline. bro you just gave yourself a bruise"

### ropemaxxing
Giving up entirely on improving looks. Self-deprecating doomer term.
> "after seeing that guy's glow-up i might just ropemaxx fr" (note: used ironically)

### pharmamaxxing
Using pharmaceuticals, peptides, hormones, and supplements to enhance appearance and performance. The pharmacological branch of looksmaxxing.
> "bro's pharmamaxxing stack costs more than his rent. TRT, accutane, melanotan, the whole pharmacy"

### leanmaxxing
Prioritizing extremely low body fat to reveal facial bone structure — cheekbones, jawline, hollow cheeks.
> "he leanmaxxed down to 10% body fat and suddenly had cheekbones from another dimension"

### starvemaxxing
Extreme calorie restriction for leanness. Disordered eating territory.
> "starvemaxxing is not the wave bro. you need protein to actually build anything"

### roidmaxxing
Using anabolic steroids for muscle growth and appearance.
> "roidmaxxing at 19. his liver is crying."

### auramaxxing
Improving your overall vibe, presence, charisma, and energy beyond physical looks. Fashion, body language, mindfulness, scents.
> "auramaxxing is the meta now. you can be a 6 face but a 9 presence"

### scentmaxxing
Optimizing fragrance through layering multiple scented products for a signature scent.
> "his scentmaxx game is so strong you can smell him from across the room. in a good way."

### sleepmaxxing
Optimizing sleep quality and duration for appearance benefits. Growth hormone, inflammation reduction, skin recovery.
> "8 hours minimum, blackout curtains, mouth tape. sleepmaxxing is the most underrated softmaxx"

### voicemaxxing
Training to develop a deeper, more resonant, dominant voice.
> "voicemaxxing with vocal exercises every morning. the baritone is coming in."

### socialmaxxing
Improving social skills, expanding social circles, and building social proof.
> "no point being a PSL 7 if you can't hold a conversation. socialmaxx first."

### NTmaxxing
Neurotypical maxxing — masking neurodivergent traits to appear more socially normal and confident.
> "he's NTmaxxing so hard nobody can tell he rehearses conversations in the mirror"

### SEAmaxxing
Traveling to Southeast Asia to improve dating prospects, under the assumption of higher relative SMV there.
> "couldn't get a date locally so now he's SEAmaxxing in Thailand. geographic arbitrage."

### thugmaxxing
Adopting an aggressive, "bad boy" or criminal aesthetic and behavior for perceived attractiveness.
> "thugmaxxing with the neck tats and the mean mug. low inhib energy."

### chewmaxxing
Chewing hard gum (mastic, falim) intensively to build masseter muscles for a wider jaw.
> "chewmaxxing for 2 hours a day. his masseters are getting visible from the front"

### collagenmaxxing
Boosting collagen levels for better skin elasticity, lip fullness, and under-eye appearance.
> "collagenmaxxing with peptides and bone broth. the skin texture improvement is real."

### jawmaxxing
Focused specifically on jawline enhancement through chewing, mewing, or surgery.
> "jawmaxxing is his entire personality. mastic gum in one hand, jaw exerciser in the other."

### eyemaxxing
Maximizing the eye area — lash serums, brow grooming, reducing dark circles, canthal tilt surgery.
> "eyemaxxing changed his whole face. under-eye concealer + brow shaping = different person"

### posturemaxxing
Improving posture for aesthetic benefits. Better posture = better side profile and jaw-neck angle.
> "posturemaxxing with chin tucks. his side profile went from recessed to forward-grown looking"

### neckmaxxing
Training neck thickness through exercises. Thicker neck = more masculine frame.
> "neckmaxxing 3x a week. went from pencil neck to actually having a frame"

### whitemaxxing
Using products or techniques to lighten skin tone. Heavily criticized.
> "whitemaxxing with glutathione IV drips. the self-hate is strong with this one"

### healthmaxxing
Focusing on overall health optimization as the foundation of appearance improvement.
> "healthmaxxing is step zero. fix your sleep, diet, and hormones before you touch anything else"

### personalitymaxxing
Actively working on personality traits to become more likable and charismatic.
> "personalitymaxxing because looks alone ain't carrying the conversation"

### charismamaxxing
Maximizing charisma and personal magnetism as an alternative or complement to physical improvement.
> "bro charismamaxxed his way into being a 7 with a 5 face. respect."

### cloutmaxxing
Maximizing social media following, fame, or viral presence as a path to perceived attractiveness.
> "cloutmaxxing on TikTok. if you can't be a mogger, become famous."

### phenomaxxing
Optimizing appearance specifically for your ethnic phenotype rather than conforming to a single standard.
> "phenomaxxing = choosing hairstyles and grooming that enhance YOUR features, not chasing someone else's look"

### jestermaxxing
Acting like a jester/clown — being funny, entertaining, doing bits to get attention and attraction. Clavicular popularized "jestermaxxing at the club is the new meta."
> "jestermaxxing at the pub is officially the new meta 💀"

---

## Mogging Terms

### mog
To dominate someone in terms of looks. To make someone look worse just by standing next to them.
> "he walked into the room and mogged every guy there without even trying"

### mogger
Someone who mogs others. A naturally good-looking person who outshines everyone around them.
> "that dude is a natural mogger. unfair genetics."

### mogged
Past tense — being made to look worse by someone better looking.
> "i got mogged at the gym today by a guy with a jawline sharper than my knife set"

### heightmog
To mog someone specifically because you're taller.
> "bro heightmogged the entire friend group at 6'4"

### facemog
To mog someone specifically because your face is better.
> "she facemogged every girl at the party and she wasn't even trying"

### bodymog
To mog someone with a superior physique.
> "he bodymogged the whole beach. everyone else looked like they just started lifting"

### brutalmogged
When you get mogged so hard it's devastating. Not even close.
> "got brutalmogged by a male model in the elevator. day ruined."

### jawmog
To mog someone specifically with a superior jawline.
> "that man jawmogs 99% of the population. it's not fair."

### AMOG
Alpha Male Of Group. The best-looking or most dominant guy in any social setting.
> "he's always the AMOG wherever he goes. rest of us are background characters"

### framemog
To mog someone with a larger, more muscular build. Wide shoulders, V-taper, physical dominance.
> "he framemogged everyone in the photo. looked like a different species."

### hairmog
To mog someone through superior hair density, thickness, or hairline.
> "full NW0 hairline at 30 while his friends are NW3. brutal hairmog."

### stylemog
To mog through superior clothing, grooming, and presentation. One of the most controllable forms.
> "walked in with a tailored fit and stylemogged every hoodie-wearing normie in the room"

### agemog
To mog by looking significantly younger than peers despite being the same age.
> "he's 35 and agemogging all his college friends. skincare + genetics."

### statusmog
When perceived social standing or success overshadows others' presence.
> "pulled up in the Tesla and statusmogged the whole parking lot"

### voicemog
When a deeper, more resonant voice dominates in social settings.
> "he voicemogged the whole podcast. everyone else sounded like they hadn't hit puberty"

### wristmog
To mog through visibly thicker wrists — indicators of larger frame and bone structure.
> "bro wristmogged him so hard. those forearms are tree trunks"

### skullmog
To dominate through superior skull/head shape, brow ridge, and cranial proportions.
> "perfect skull shape + hunter eyes. skullmogged into oblivion."

### overallmog
Dominating across multiple categories simultaneously — height, face, frame. The most devastating form.
> "6'3, hunter eyes, sharp jaw, wide frame. overallmogged the entire venue."

### gigamogger
Someone who is extremely attractive and mogs almost everyone they encounter.
> "that dude is a gigamogger. doesn't even have to try."

---

## Eye Area

### canthal tilt
The angle of the eye from inner corner to outer corner. Positive (upward tilt) = attractive. Negative (downward tilt) = less ideal.
> "bro got a positive canthal tilt and still can't get a text back 💀"

### PCT
Positive Canthal Tilt. Outer eye corner higher than inner corner. The desirable eye angle.
> "PCT + deep set eyes = automatic mogger status"

### NCT
Negative Canthal Tilt. Outer eye corner lower than inner corner. Considered undesirable.
> "NCT is brutal but canthoplasty exists. hardmaxx it."

### hunter eyes
Deep-set, hooded, intense eyes with a positive canthal tilt. The ideal eye area in looksmaxxing.
> "hunter eyes + sharp jawline = it's over for everyone else"

### prey eyes
The opposite of hunter eyes — round, wide, exposed upper eyelid. Considered less attractive.
> "he's got prey eyes but copes by wearing glasses 24/7"

### IPD
Inter-pupillary distance. The space between your pupils. There's an "ideal" range for facial harmony.
> "his IPD is perfect, that's why his face looks so symmetrical"

### upper eyelid exposure
How much of your upper eyelid is visible. Less = hunter eyes, more = prey eyes.
> "too much upper eyelid exposure. needs an eye cream or surgery"

### UEE
Abbreviation for Upper Eyelid Exposure. Less is considered better in men.
> "minimal UEE is one of the biggest halos for the male eye area"

### orbital rim
The bone around your eye socket. Prominent orbital rims = deep-set eyes = more masculine look.
> "his orbital rims are insane, eyes look like they're set in stone"

### infraorbital rim
The bone directly under the eye socket. Key factor in the "hunter eyes" look. Can be augmented with implants.
> "strong infraorbital rims = no under-eye hollowing = no tired look"

### scleral show
When the white of your eye is visible below the iris. Generally considered unattractive.
> "the scleral show is giving exhausted office worker, not mogger"

### hooded eyes
Eyes with an extra fold of skin covering the upper eyelid crease. Considered masculine and attractive.
> "hooded eyes + brow ridge = natural hunter eye look without surgery"

### almond eyes
Symmetrically tapered eyes with visible crease. Considered the ideal eye shape.
> "almond eyes are the gold standard. not too round, not too narrow."

### deep set eyes
Eyes set farther back in the skull, making the brow ridge more prominent. Masculine look.
> "deep set eyes make the brow ridge pop. natural mogger feature."

### bug eyes
Large, protruding eyes that are not deep-set enough. Considered unattractive. Also called beta eyes.
> "bug eyes are a brutal failo. nothing you can do except maybe orbital rim implants"

### sanpaku eyes
Eyes where white is visible above or below the iris. Considered unsettling or intense.
> "sanpaku eyes are either creepy or mysterious depending on who you ask"

### siren eyes
Elongated, almond-shaped eye look with upward-tilted outer corners creating a seductive gaze. Female equivalent of hunter eyes.
> "siren eyes makeup is basically female hunter eyes. the dark feminine energy."

### doe eyes
Wide, round, open eyes with soft appearance. Feminine counterpart to prey eyes but considered desirable for women.
> "doe eyes on women = cute. prey eyes on men = it's over. the double standard."

### orbital vector
Positive orbital vector = infraorbital area well-projected, balanced eye appearance. Negative = sunken, tired look.
> "negative orbital vector is giving hollow skull energy. needs infraorbital rim implant."

---

## Facial Structure

### jawline
The lower edge of the jaw. Sharp, defined jawline = king. Weak jawline = cope.
> "his jawline could cut glass. natural mogger behavior."

### gonial angle
The angle of your jaw at the back corner. A sharper angle = more masculine, chiseled jaw.
> "his gonial angle is like 110 degrees. that jaw was ENGINEERED"

### gonion
The corner point of the jaw where the ramus meets the mandible body. Well-defined gonion = sharp jaw angle.
> "his gonions are so sharp they cast shadows. based genetics."

### ramus
The vertical part of the jawbone behind your cheek. Longer ramus = more jaw definition.
> "long ramus + good gonial angle = jawline that mogs from every angle"

### mewing
Keeping your tongue pressed against the roof of your mouth to supposedly improve jawline and facial structure over time. The foundational looksmaxxing technique.
> "been mewing for 2 years. the jaw is different. trust the process."

### forward growth
Facial bones growing forward rather than downward. The goal of mewing. Associated with attractive faces.
> "you can tell he had good forward growth as a kid. lucky genetics"

### recession
When the jaw or midface doesn't develop forward enough. Recessed chin = it's over (according to the community).
> "his chin recession is brutal. mewing won't save that, only surgery"

### maxilla
The upper jaw bone. A well-developed maxilla = good cheekbones, forward growth.
> "the maxilla is everything. if your midface is recessed, nothing else matters"

### mandible
The lower jaw. Strong mandible = strong jaw = strong mog potential.
> "that mandible is doing all the work. nature's gift."

### zygos / zygomatic bones
Cheekbones. Pronounced zygos = model tier facial structure.
> "his zygos are popping. cheekbone game is elite"

### midface ratio
The proportion of your midface (eyes to mouth). Shorter midface = generally considered more attractive.
> "short midface ratio is the cheat code. makes everything look more compact and aesthetic"

### compact midface
A short distance between eyes and mouth. One of the most prized facial proportions.
> "compact midface is the difference between HTN and Chadlite. it compresses everything into harmony."

### philtrum
The groove between your nose and upper lip. Shorter philtrum = more attractive (allegedly).
> "his philtrum is so short it's basically nonexistent. genetic lottery winner"

### chin
Not just "chin" — in looksmaxxing, it's about chin projection, width, and shape. Everything matters.
> "weak chin? genio or cope for life"

### chin projection
How far forward the chin extends from the face. More projection = stronger profile.
> "his chin projection is perfect. side profile that mogs."

### clavicle
The collarbone. Prominent, wide clavicles = broader frame = more dominant look. The namesake of the legend himself.
> "clavicle game is CRAZY on that frame. built like a greek statue"

### lower third
Bottom third of the face — jaw and chin area. Critical in PSL ratings.
> "his lower third is carrying his entire face. jaw and chin doing all the work."

### facial thirds
Face divided into three horizontal zones that should be roughly equal for facial harmony.
> "his upper third is too long. forehead throwing off the facial thirds ratio."

### facial harmony
How well facial features work together proportionally. Weighted ~40% in rating formulas.
> "facial harmony > any single feature. you can have hunter eyes and still be mid if nothing matches."

### fWHR
Facial Width-to-Height Ratio. Key attractiveness/dominance metric. Ideal male range: 1.75-2.0.
> "his fWHR is off the charts. face is wide and compact. pure dimorphism."

### bigonial width
Distance between the two jaw corners (gonions). Ideal is 70-75% of bizygomatic width for masculine aesthetics.
> "narrow bigonial width is why his jaw looks weak even though his chin is fine"

### bizygomatic width
Distance between the cheekbones. Determines overall facial width.
> "wide bizygomatic width = wide face = dominant look. it's all about the bones."

### hollow cheeks
Concave cheek area from prominent cheekbones and low body fat. A primary aesthetic goal.
> "leanmaxxed down to 11% and the hollow cheeks appeared. the bone structure was hiding under the fat."

### ogee curve
S-shaped contour from cheekbones through the midface. Well-defined ogee curve = youthful, attractive.
> "his ogee curve is textbook. cheekbone-to-cheek transition is smooth and defined."

### brow ridge
The bony ridge above the eyes. Creates natural eye hooding. Key dimorphism feature.
> "prominent brow ridge = natural hunter eyes without surgery. genetic advantage."

### nasolabial folds
Creases running from nose wings to mouth corners. Considered an aging sign and failo.
> "nasolabial folds at 22 is brutal. tretinoin and filler or cope."

### submental fat
Fat under the chin creating a double chin appearance. First target in debloating.
> "submental fat is hiding his jawline. needs to cut or get lipo."

### anteface
Forward protrusion of the middle and lower face in profile. Associated with good forward growth.
> "strong anteface = forward-grown face = attractive side profile"

### rat face
Long midface, narrow skull, receding chin. Considered very unattractive.
> "rat face is one of the worst facial archetypes. everything is elongated and recessed."

### neoteny
Retention of youthful features into adulthood. High neoteny in women = attractive. Moderate in men = balance of youth and masculinity.
> "he's got that neoteny going on. looks 22 at 30. agemogging everyone."

### angularity
How sharp and defined facial bone structure appears. High angularity = chiseled features.
> "high angularity is what separates Chadlites from Chads. shadows on the face."

### malar
The most prominent point of the zygomatic bone. High malar projection = model-tier cheekbone definition.
> "his malar projection is insane. cheekbones you can see from across the room."

### facial convexity
Profile view measurement of how forward-grown the face is. 165+ degrees = forward grown (desirable).
> "tested my facial convexity and it's 168. forward growth gang."

---

## Rating & Classification

### PSL
The rating scale used in the looksmaxxing community. Scale of 1-10 but 6+ is considered attractive.
> "he's a PSL 6 on a good day. with a haircut maybe 6.5"

### PSL god
Someone at the very top of the PSL scale. Essentially perfect facial genetics.
> "that dude is a PSL god. every feature is optimized."

### subhuman
PSL 1-3. Very unattractive. Used self-deprecatingly in the community.
> "i looked subhuman in that photo ngl. delete it immediately"

### sub5
Below 5 on PSL scale. Below average. Often used as a self-deprecating identity.
> "sub5 life is a different experience. lookism hits different when you're below average."

### normie
PSL 4-5. Average looking. Not ugly, not standing out.
> "most people are normies and that's fine but we're trying to ascend here"

### LTN
Low Tier Normie. PSL 3.5-4.5. Slightly below average.
> "he's LTN but with a good stylemaxx could pass for MTN"

### MTN
Mid Tier Normie. PSL 4.5-5.5. Average looking. The statistical middle.
> "MTN is where most guys sit. not ugly, not turning heads."

### HTN
High Tier Normie. PSL 5-5.5. Above average but not head-turning.
> "he's HTN at best. cute but not stopping traffic"

### Brad
Moderately attractive male. A step below Chadlite. Average good-looking guy.
> "he's a Brad. gets dates but doesn't mog anyone."

### Chadlite
PSL 6-7. Clearly attractive. Gets attention.
> "bro ascended to Chadlite after the gym arc and skincare routine"

### Chad
PSL 7-8. Very attractive. Natural mogger.
> "he walked in and everyone knew he was the Chad of the group"

### Gigachad
PSL 9-10. Unrealistically attractive. Meme-tier good looking.
> "that dude is a Gigachad. not even competing in the same league as the rest of us"

### Tera Chad
Above Gigachad. The absolute theoretical peak of male attractiveness. Meme tier.
> "Tera Chad doesn't exist in real life. it's a mathematical concept at this point."

### Stacy
Female equivalent of Chad. Very attractive woman.
> "she's a full Stacy. the whole room stopped when she walked in"

### Stacylite
Female equivalent of Chadlite. Attractive but not peak-tier.
> "she's Stacylite. turns heads but not stopping traffic."

### Becky
Female equivalent of normie/HTN. Cute but not stunning.
> "she's a Becky trying to Stacymaxx. respect the grind."

### Tyrone
Black male equivalent of Chad. Extremely attractive Black man.
> "that dude is a Tyrone. mogger genetics."

### Chang
East Asian male equivalent of Chad.
> "Chang walked in and everyone's girl started looking"

### Chadpreet
South Asian male equivalent of Chad.
> "Chadpreet out here mogging with that jawline and full beard"

### Chaddam
Arabic/Middle Eastern male equivalent of Chad.
> "Chaddam with the beard and the bone structure. it's unfair."

### manlet
Derogatory term for a short man. Usually under 5'8-5'9.
> "manlet cope is thinking personality matters more than being 6'0"

### lanklet
Tall but very skinny/unattractive man. Height without frame or muscle.
> "lanklet energy. 6'2 but weighs 140. height without frame is a waste."

### chadlet
A short man who is otherwise facially attractive. Chad face, manlet height.
> "chadlet problems: mogs in photos, gets heightmogged irl"

### pretty boy
An attractive male with relatively feminine facial features. High neoteny.
> "pretty boy aesthetic is valid but different from the dimorphism mogger look"

### sigma
A male who operates outside the alpha/beta hierarchy. The "lone wolf" archetype.
> "sigma grindset: mewing alone in his room at 3am"

### it's over
Giving up. When someone's looks are beyond saving (used dramatically/ironically).
> "negative canthal tilt AND recessed chin? it's over bro"

### it's never began
Even worse than "it's over." It was always hopeless.
> "bro said 'it never began for me' after seeing his side profile 💀"

### ascend
To level up your looks. Go from lower PSL to higher.
> "he ascended from a 4 to a 7 in one year. looksmaxxing actually works."

### ascension
A significant, noticeable improvement in appearance. The glow-up that makes people double-take.
> "his ascension from sophomore to senior year was INSANE. different person."

### descension
Opposite of ascension. A decline in attractiveness.
> "the descension from drinking and no sleep is real. went from HTN to LTN."

### NGMI
Not Gonna Make It. Someone who won't improve because they won't put in the work.
> "still eating fast food every day and wondering why the jawline isn't coming in. ngmi."

### WAGMI
We're All Gonna Make It. Motivational. Everyone can improve.
> "started from a 3, now i'm a 5.5. wagmi kings 👑"

### maxxed out
Having optimized an area to its genetic or practical limit. No further improvement possible.
> "his jawline is maxxed out. no more gains from chewing or surgery."

### genetic ceiling
The maximum attractiveness achievable given one's genetics.
> "everybody has a genetic ceiling. looksmaxxing helps you reach it, not exceed it."

---

## -Cel Terms

### incel
Involuntarily celibate. Unable to find a sexual partner despite wanting one.
> "the word incel got ruined but it literally just means you can't get a date"

### truecel
Someone genuinely at the bottom of the attractiveness scale with unchangeable features. The most hopeless tier.
> "truecel is PSL 1-2. deformity-level. no amount of maxxing saves it."

### fakecel
Someone who claims to be incel but has had recent relationships or is actually decent-looking.
> "bro posted 'rate me' with a defined jaw and hunter eyes. fakecel detected."

### volcel
Voluntarily celibate. Someone who chooses not to pursue sex/relationships.
> "volcel is different from incel. one is a choice, the other isn't."

### mentalcel
Incel due to mental health issues (anxiety, autism, depression) rather than physical appearance.
> "mentalcel with a PSL 6 face. the social anxiety is what's holding him back."

### gymcel
An incel who exercises hoping fitness will make him attractive, but the issue is facial/skeletal.
> "gymcel with a great body and a PSL 3 face. the gym can't fix bone structure."

### baldcel
Incel primarily due to hair loss/baldness.
> "baldcel at 21. got on fin too late. the norwood reaper shows no mercy."

### framecel
Incel due to narrow/weak skeletal frame.
> "framecel with 15 inch shoulders. even gymmaxxing can't fix bone width."

### wristcel
Incel who fixates on thin wrists as indicator of small overall frame.
> "wristcel measuring his wrists every morning. 5.5 inches and coping."

### heightcel
Incel who attributes their situation primarily to short stature.
> "heightcel at 5'5. the heightpill is brutal and real."

### ethniccel
Non-white incel who attributes celibacy to racial/ethnic disadvantage in dating.
> "ethniccel discourse is toxic but the data on dating app match rates is real"

### currycel
South Asian male incel. Community-specific term.
> "currycel coping with 'just be confident bro.' the racepill hurts."

### ricecel
East/Southeast Asian male incel. Community-specific term.
> "ricecel blaming everything on race when he hasn't tried skinmaxxing once"

### femcel
A female who identifies as involuntarily celibate. The female counterpart.
> "femcel community has its own version of lookism discourse"

### KHHV
Kissless, Handholdless, Hugless Virgin. Maximum inexperience flag.
> "KHHV at 23 is brutal but it's not over. socialmaxx and ascend."

---

## -Pill Terms

### blackpill
The doomer philosophy that looks are everything and genetic losers can't improve. Fatalistic.
> "he took the blackpill and stopped trying. sad arc."

### redpill
Awareness of social dynamics and lookism. Less extreme than blackpill.
> "getting redpilled on looks theory changed how i see everything"

### bluepill
Willful ignorance about dating dynamics. Mainstream "just be yourself" belief.
> "bluepilled normie thinks personality > looks. wait till he sees the tinder data."

### whitepill
Accepting blackpill realities but still pursuing self-improvement. Optimistic counterpart.
> "whitepilled king. knows looks matter but still mewing and gymmaxxing every day."

### purplepill
Positioned between bluepill and redpill ideologies.
> "purplepilled = looks matter but so does personality. the centrist take."

### pinkpill
The femcel version of the blackpill. Focuses on female experiences of lookism and beauty standards.
> "pinkpill discourse on r/Vindicta hits different"

### agepill
The realization that aging irreversibly reduces attractiveness.
> "took the agepill at 28 when the first nasolabial folds appeared. time is undefeated."

### heightpill
The realization that height significantly impacts dating success.
> "the heightpill is just data. 6'0+ gets 3x more matches. brutal."

### racepill
The belief that race/ethnicity plays a major role in dating success. Heavily debated.
> "racepill discourse always ends in a flame war. nobody wins."

### neckpill
The realization that neck width/thickness dramatically impacts facial harmony and frame.
> "took the neckpill and started neck curls. went from pencil neck to actually looking masculine."

### bonepill
The realization that bone structure determines attractiveness and can't be easily changed.
> "the bonepill is the hardest pill to swallow. you can't mew your way to a new skull."

### Y-pilled
Viewing oneself as more masculine than others. References the Y chromosome.
> "Y-pilled and based. walking around like testosterone is leaking from his pores."

---

## Techniques & Practices

### chewing
Using hard gum (like mastic gum or falim) to build jaw muscles (masseter hypertrophy).
> "been chewing mastic gum for 3 months. masseters are getting SWOLE"

### mastic gum
Extra-hard gum used for jaw muscle development. A staple of the looksmaxxing toolkit.
> "ordered mastic gum off amazon. jawline arc starts now."

### falim gum
Turkish hard gum, cheaper alternative to mastic gum for jaw training.
> "falim gum is the budget option for jaw gains. still works."

### cold exposure
Cold showers, ice baths — supposedly improves skin, reduces puffiness, increases testosterone.
> "cold showers every morning for the skin gains. suffering = ascending"

### minoxidil
Hair growth treatment applied to beard/face area to grow facial hair (off-label use).
> "minoxidil beard is coming in. 3 months in and the cheeks are filling out"

### tretinoin
Vitamin A derivative for skin. Nuclear option for acne and skin texture.
> "tretinoin purge was brutal but the skin on the other side is GLOWING"

### dermarolling
Rolling tiny needles on your face to boost collagen. Skincare technique.
> "dermarolling once a week. the texture improvement is real."

### tongue posture
How you rest your tongue in your mouth. Flat against the palate = mewing. Foundation of everything.
> "fix your tongue posture before you try anything else. it's step zero."

### orthotropics
The dental/facial growth philosophy behind mewing. Developed by Mike Mew's father.
> "orthotropics is the science, mewing is the practice. know the difference."

### hard mewing
Intense, forceful version of mewing with strong tongue pressure. Generally not recommended — TMJ risks.
> "hard mewing gave him TMJ. just do regular mewing bro."

### chin tuck
Posture exercise pulling chin straight back to correct forward head posture. Foundational softmaxx.
> "chin tucks fixed his side profile more than anything else. posture is underrated."

### face pulling
Techniques claiming to pull the maxilla forward through manual pressure or devices. Controversial/pseudoscience.
> "face pulling for 6 months and no results. shocking. /s"

### thumb pulling
Using thumbs on the palate to attempt maxilla expansion. Highly debated effectiveness.
> "thumb pulling technique is either genius or cope depending who you ask"

### debloat
Reducing facial water retention and puffiness through diet, reducing sodium/alcohol, drinking water.
> "debloated after cutting alcohol for a month. the jawline was hiding under the water weight."

### subliminals
Audio tracks with hidden affirmations believed to change physical appearance. Pure cope or placebo.
> "listening to subliminals for hunter eyes. bro just get canthoplasty."

### shoe lifts / elevator shoes
Inserts or shoes that add height discreetly. Common heightmaxxing tool.
> "elevator shoes adding 3 inches. fraudmaxxing his height on every date."

### nofap / semen retention
Abstaining from masturbation, believed to boost testosterone and improve appearance.
> "nofap day 30 and he thinks his jaw got wider. the placebo is strong."

### beta carotene
Carotenoid supplement for a golden/healthy skin glow. Basis of "carrot theory."
> "beta carotene giving him that warm skin tone. carrot theory is legit."

---

## Surgery & Procedures

### genio / genioplasty
Chin surgery. Sliding genioplasty moves the chin bone forward.
> "he got a genio and his side profile went from a 4 to a 7. hardmaxxing works."

### rhino / rhinoplasty
Nose job. One of the most common hardmaxxing procedures.
> "the rhino transformed his whole face. nose was holding everything back."

### buccal fat removal
Removing fat from the cheeks for a more hollow, chiseled look.
> "buccal fat removal gave him cheekbones from another dimension"

### filler
Injectable filler (usually hyaluronic acid) for chin, jaw, under-eyes, etc.
> "a little filler in the jaw and he went from normie to HTN. subtle hardmaxx."

### bimax
Bimaxillary osteotomy. Double jaw surgery repositioning both maxilla and mandible. One of the most impactful hardmaxxing procedures.
> "bimax is the nuclear option. $40k but it literally restructures your face."

### BSSO
Bilateral Sagittal Split Osteotomy. Most common mandibular advancement surgery.
> "BSSO moved his lower jaw forward 8mm. side profile completely different."

### Le Fort
Classifications of maxillary surgery (I, II, III). Le Fort I is most common — repositions upper jaw.
> "Le Fort I + BSSO = full bimax. the hardmaxx endgame."

### canthoplasty
Permanent surgical repositioning of the outer eye corner to create positive canthal tilt.
> "canthoplasty to fix NCT. went from prey eyes to hunter eyes."

### canthopexy
Temporary version of canthoplasty lasting ~6 years.
> "canthopexy is the less permanent option. still changes the eye area drastically."

### blepharoplasty
Eyelid surgery removing excess skin/fat from upper/lower eyelids. Reduces UEE.
> "upper bleph gave him hooded eyes. hunter eye effect without touching the canthal tilt."

### custom jaw implant
3D-designed silicone implant wrapping around the entire jawline.
> "custom wrap-around jaw implant from Eppley. $25k but the jaw is literally sculpted."

### infraorbital-malar implant
Custom implant under the eye and over the cheekbone. Improves ogee curve and midface projection.
> "infraorbital-malar implant fixed his negative orbital vector. eyes look supported now."

### Eppley
Dr. Barry Eppley — the plastic surgeon most referenced for custom facial implant work. His name is shorthand for high-end custom implants.
> "saving up for Eppley. custom jawline implant is the dream."

### fox eye lift
Surgical or thread-based procedure lifting the outer canthal area for elongated eyes. Major female looksmaxxing trend.
> "fox eye lift is basically surgical siren eyes. bella hadid effect."

### masseter botox
Botox injection into jaw muscles to slim the lower face for V-shaped jawline.
> "masseter botox is more of a female looksmaxx. slims instead of widens."

### lip flip
Botox at the upper lip border to "flip" the lip outward slightly for fuller appearance.
> "lip flip is subtler than filler. just makes the upper lip more visible."

### MSE
Maxillary Skeletal Expander. Titanium palatal expansion device screwed into palate bone.
> "MSE expanded his palate 5mm. face got wider. breathing got better."

### SARPE
Surgically Assisted Rapid Palatal Expansion. Splits and widens the palate.
> "SARPE is MSE but with surgery. for when the sutures are already fused."

### limb lengthening / LL
Surgery that breaks and gradually extends leg bones to gain height. $50-100K, months of recovery.
> "LL to go from 5'8 to 5'11. $75k and 6 months of suffering."

### hair transplant
Surgical procedure moving hair follicles from donor area to balding areas.
> "hair transplant at 25 saved his hairline. NW3 back to NW1."

### Ozempic face
Facial volume loss, hollowing, and premature aging from rapid GLP-1 weight loss. The dark side of leanmaxxing.
> "Ozempic face is real. lost the weight but gained 10 years on his face."

### GHK-Cu
Copper peptide. Increases collagen synthesis up to 70%. Used for skin regeneration, anti-aging, hair growth.
> "GHK-Cu is the top-tier pharmamaxx peptide. skin regeneration on another level."

### BPC-157
Body Protection Compound peptide for tissue repair and recovery. "Duct tape for the body."
> "BPC-157 alongside tretinoin for skin repair. the recovery stack."

### semaglutide / tirzepatide
GLP-1 weight loss medications (Ozempic, Wegovy, Mounjaro). Called "the single biggest cheat code for face ascension."
> "semaglutide revealed bone structure he didn't know he had. leanmaxxing via injection."

### dutasteride
Stronger alternative to finasteride for hair loss. Blocks more DHT. The "nuclear option" for hairline preservation.
> "dutasteride when fin isn't enough. saving every follicle possible."

---

## Body Terms

### frame
Your skeletal structure — shoulder width, ribcage, hip width. Can't really change it.
> "wide frame + narrow waist = V-taper mogger. genetics are everything"

### V-taper
Wide shoulders narrowing to a slim waist. The ideal male physique shape.
> "hit back day hard enough and the V-taper will come. trust."

### insertions
Where your muscles attach to your bones. Determines muscle shape. Genetic.
> "his bicep insertions are insane. low inserts = peak arms."

### gyno / gynecomastia
Male breast tissue development. A common insecurity in the community.
> "he's gymmaxxing but the gyno is holding him back. might need surgery."

### bloatmaxxed
Carrying too much water weight or fat, hiding your features.
> "bro is bloatmaxxed rn. needs to cut and the jawline will reveal itself"

### natty
Natural, no steroids or PEDs.
> "claims natty but gained 30lbs of muscle in 4 months. sure bro."

### juicing
Using steroids or PEDs to build muscle faster.
> "juicing and still can't bench 225. waste of gear."

### lean
Being at a low body fat percentage. Makes facial features more visible.
> "bro got lean and suddenly had cheekbones. the fat was hiding a mogger."

### wrist size
Indicator of overall skeletal frame size. Small wrists = small frame.
> "5.5 inch wrists. framecel confirmed."

### masseter
The jaw muscle that can be trained with gum chewing for a wider jaw.
> "masseters growing from 3 months of mastic gum. jaw width is finally visible."

### water retention
Excess water held in tissues causing facial puffiness. Enemy of facial definition.
> "water retention from sodium is hiding his jawline. debloat immediately."

---

## Culture & Community Slang

### cope
A lie you tell yourself to feel better about your situation. Also: a strategy that doesn't actually work.
> "wearing a hat to hide your hairline is pure cope"

### copium
The metaphorical substance you inhale when you're coping hard.
> "massive amounts of copium in that comment section. no one wants to hear the truth"

### rope
Giving up entirely. Blackpill doomer energy. Used ironically in the community.
> "showed my looksmatch and she said 'ew.' time to rope"

### blackpill
(See -Pill Terms section)

### redpill
(See -Pill Terms section)

### halo effect
When one attractive feature makes everything else about you seem better.
> "good jawline = halo effect. people assume you're smart, funny, and interesting."

### failo effect
The opposite of halo effect. One bad feature makes everything seem worse.
> "his nose is giving failo effect to his whole face. one feature dragging everything down."

### looksmatched
When two people in a relationship are equally attractive.
> "they're so looksmatched it's actually cute. both solid 6.5s"

### lookism
Discrimination based on physical appearance. The core philosophical concept.
> "lookism is everywhere. better looking people literally make more money."

### pretty privilege
The documented social and economic advantages attractive people receive.
> "pretty privilege is backed by research. halo effect in action everywhere."

### norwood
The Norwood scale measures male pattern baldness. Higher number = more hair loss.
> "bro is at Norwood 3 and still in denial. get on fin before it's too late."

### NW
Abbreviation for Norwood (hair loss level).
> "NW2 isn't bad yet but you need to hop on treatment NOW"

### Norwood Reaper
Personified meme of the Norwood scale. The inevitability of hair loss coming for everyone.
> "the Norwood Reaper spares no one. get on fin or meet your fate."

### DHT
Dihydrotestosterone. Hormone that causes male pattern baldness, facial hair growth, and acne.
> "DHT is both the jawline hormone and the baldness hormone. pick your poison."

### fin
Finasteride — medication for hair loss prevention.
> "got on fin at 19. saving my hairline before it's too late."

### min
Minoxidil — topical treatment for hair growth.
> "min + fin combo is the meta for hair loss. don't skip either."

### LDAR
Lay Down And Rot. Giving up on everything. The most blackpilled action.
> "he said he's just gonna LDAR. bro get up and at least mew."

### glow up
A noticeable improvement in appearance over time. The goal.
> "his glow up from freshman to senior year was INSANE. literally different person."

### rate me
Asking the community to rate your face/looks on the PSL scale.
> "posted a 'rate me' and the comments were BRUTAL. never again."

### irl
In real life — as opposed to how you look in photos/videos.
> "he's a PSL 7 in photos but irl it's more like a 5. fraudmaxxing with angles"

### genetic lottery
The randomness of the genes you were born with. The ultimate cope/celebration.
> "tall, symmetric face, hunter eyes. bro won the genetic lottery and doesn't even mew"

### dimorphism
Sexual dimorphism — how masculine (male) or feminine (female) your features are.
> "high dimorphism = strong jaw, brow ridge, deep voice. the mogging trifecta."

### aesthetics
The overall visual harmony and attractiveness of your face and body.
> "aesthetics over everything. you can be big but if you're not aesthetic it doesn't hit the same"

### SMV
Sexual Market Value. How attractive you are in the "dating market."
> "his SMV shot up after the glow up. suddenly everyone's interested."

### foid
Derogatory community slang for women (short for "femoid"). Used in blackpill/incel-adjacent spaces.
> "group of foids walked in and he forgot how to mew. cortisol through the roof"

### moid
The male equivalent of foid. Man/male in community slang.
> "he's out there mogging every moid in the venue without even trying"

### jestergooning
Acting like a jester/clown in public for attention and content. Chaotic behavior for the camera.
> "bro was jestergooning in public and got caught on someone's story 💀"

### chadfishing
Pretending to be a Chad using fake photos to test how differently attractive people get treated.
> "he went chadfishing on tinder and the responses were insane. lookism is real."

### munting
Making exaggerated facial expressions or poses, often grotesque or comedic. Jestermaxxing for content.
> "he was munting so hard in the background of that photo. absolute menace."

### cortisol
In community context: stress hormone that spikes when mogged or encountering social pressure. Used semi-ironically.
> "she looked at him and his cortisol levels went through the ceiling"

### nootropics
Cognitive enhancement supplements/drugs. The biohacking side of maxxing.
> "his nootropic stack has him studying and mewing at the same time. efficiency mogger"

### melanotan
Peptide that dramatically increases tanning response. Part of the pharmamaxxing toolkit.
> "hit the melanotan and now he's 5 shades darker in a week. skin color speedrun"

### aura
Overall vibe, presence, energy beyond physical features. Confidence, body language, charisma.
> "his aura is a 9 even though his face is a 6. some people just have IT."

### mirin
Short for "admiring." When someone is checking you out or clearly impressed.
> "caught her mirin at the gym. the looksmaxx is paying off."

### JFL
Just Fucking Lol. Expression of incredulous laughter at something absurd.
> "JFL at thinking mewing for 2 weeks will change your bone structure"

### GTFIH
Get The Fuck In Here. Used to draw attention to something noteworthy in forums.
> "GTFIH this dude's glow up is INSANE"

### BTFO
Blown The Fuck Out. Utterly defeated or proven wrong.
> "his argument got BTFO when someone posted the before/after"

### based
Speaking uncomfortable truths without caring about reactions. Highest compliment for a take.
> "that's the most based thing anyone's said in this thread"

### brutal
Harsh, unflinching criticism or truth about someone's appearance.
> "that side profile analysis was BRUTAL. no cope left."

### high IQ / low IQ
NOT about intelligence. "High IQ" = agreement/approval. "Low IQ" = disagreement.
> "high IQ take. bone structure really is 80% of the equation."

### buddy boyo
Condescending term of address. Sarcastic "pal."
> "sure thing buddy boyo. keep coping."

### NPC
Someone who lacks independent thought. Just follows trends mindlessly.
> "NPC normies don't even know what their canthal tilt is"

### NEET
Not in Education, Employment, or Training.
> "NEET and LDARing. the blackpill arc."

### BDD
Body Dysmorphic Disorder. Obsessive concern about perceived appearance flaws.
> "half this forum has BDD and doesn't know it. no you're not subhuman."

### RTT
Roided, Tatted, Tanned. The "bad boy" aesthetic.
> "RTT look is the thugmaxx endgame. low inhib energy."

### DOM
Dominant. Ultra-masculine face or intimidating presence.
> "DOM phenotype with the brow ridge and jaw. looks like he could fight a bear."

### mascthetic
Combination of masculine and aesthetic. The ideal balance.
> "mascthetic is the goal. masculine but harmonious. not brutish, not pretty boy."

### ogre
Someone with brutish, unattractive masculine features. Too much dimorphism without harmony.
> "he's got ogre-tier features. strong but not aesthetic."

### rizz
Charisma. The ability to charm someone. Mainstream Gen Z term adopted by the community.
> "face is a 5 but his rizz is a 10. socialmaxxing carried him."

### oneitis
Unhealthy obsessive fixation on one specific person. Treated as a disease to cure.
> "oneitis is the enemy of ascension. there are 4 billion women bro."

### orbiter
Someone who hangs around a person hoping for romantic attention, never getting it.
> "he's been her orbiter for 3 years. just approach someone else."

### the wall
The age at which attractiveness sharply declines. Controversial concept.
> "hit the wall at 35. the agepill is real."

### chadification
The complete process of transforming to Chad-tier through looksmaxxing.
> "full chadification arc: genio, rhino, gym, skincare. 2 years and a different person."

---

## -Fuel Terms

### lifefuel
Something positive and motivating. Good news for your prospects.
> "that glow up is LIFEFUEL. if he can do it, anyone can."

### suifuel / suicidefuel
Something extremely demoralizing or demotivating. The opposite of lifefuel.
> "seeing his ex with a gigachad is pure suifuel"

### ragefuel
Something infuriating. Makes your blood boil.
> "pretty privilege in action is ragefuel. same resume, better looking = hired."

---

## Social & Dating Terms

### LMS
Looks, Money, Status. The three factors believed to determine dating success.
> "LMS is the framework. looks first, money second, status third."

### hypergamy
The belief that women always seek to "mate upward" in status and looks.
> "hypergamy is just evolutionary psychology. people want the best they can get."

### AWALT
"All Women Are Like That." Stereotyping term about female behavior.
> "AWALT is a cope for not understanding that individuals differ."

### 80/20 rule
Belief that 80% of women desire only the top 20% of men.
> "the 80/20 rule from tinder data. bottom 80% fighting for scraps."

### juggernaut law
Theory that the most unattractive women get disproportionate male attention because men assume they're "easy."
> "juggernaut law explains why even the lowest-rated women get more matches than average men"

### high inhib
High inhibition. Being overly self-conscious and passive in social situations.
> "high inhib is the biggest ascension blocker. looks don't matter if you can't approach."

### low inhib
Low inhibition. Confident, not caring what others think. Perceived as alpha.
> "low inhib + decent looks = slayer. confidence multiplies your PSL."

### NT
Neurotypical. Socially normal. Able to function naturally in social settings.
> "NT is the biggest advantage after looks. social skills are a multiplier."

### slayer
Alpha male who easily has sex with multiple partners.
> "slayer status achieved. the looksmaxx + socialmaxx combo paid off."

### betabuxx
A man exploited financially by a partner. Provides money in exchange for companionship.
> "betabuxx strategy: make enough money that your face doesn't matter. sad arc."

### simp
A man seen as overly kind or supportive of women to gain their favor.
> "simping in her DMs while she texts her Chad bf. classic."

### cold approach
Meeting strangers in public to seek dates. Requires low inhib.
> "cold approach is the ultimate NT check. if you can't do it, NTmaxx first."

### IOI
Indicator of Interest. Perceived signals that a woman is interested.
> "she gave 3 IOIs and he still didn't approach. high inhib moment."

### PUA
Pickup Artist. Someone who studies techniques to seduce women.
> "PUA is pre-looksmaxxing era cope. you can't technique your way past a PSL 3 face."

### MGTOW
Men Going Their Own Way. Male separatist philosophy avoiding women.
> "MGTOW is just organized cope. most of them would date if they could."

### looks theory
Theory that physical looks matter most in dating and life outcomes.
> "looks theory is just the halo effect applied to everything. science backs it."

### bone law
Male aesthetics determined by skeletal frame and facial bone structure. The fundamental axiom.
> "bone law is brutal. you can't outwork bad genetics. you can only optimize."

---

## Theories & Concepts

### carrot theory
The belief that yellowish/golden skin from carotenoids signals health and is attractive.
> "carrot theory is legit. beta carotene gives that warm skin glow."

### bald theory
You can't achieve 8+ PSL unless you also look good bald. Tests face + skull without hair.
> "bald theory check: shave your head. if you still look good, your bones carry."

### wrist theory
Wrist thickness as reliable indicator of overall frame size and genetic potential.
> "wrist theory says 7+ inches = large frame. cope for wristcels."

### neck theory
Neck characteristics (thickness, length) significantly affect perceived masculinity and attractiveness.
> "neck theory is underrated. pencil neck ruins even a good jaw."

---

## Female Looksmaxxing

### Vindicta
Female looksmaxxing community focused on "weaponized beauty."
> "Vindicta girls are the female equivalent of looksmaxxers. ruthless optimization."

### Splendida
Reddit community for women who are already attractive and want to maximize further. Step above Vindicta.
> "Splendida is for girls who are already Stacylite and want to reach Stacy."

### clean girl aesthetic
Minimalist beauty — glowing skin, slicked hair, minimal makeup. Female softmaxxing.
> "clean girl aesthetic is the female version of softmaxxing. effortless but calculated."

---

## Tech & Apps

### Moggr
AI-powered looksmaxxing app for trying hairstyles and getting facial analysis ratings.
> "Moggr said I'd look better with curtain bangs. the AI knows."

### Chadify
AI facial analysis service measuring harmony, dimorphism, angularity with "chadification" suggestions.
> "got a Chadify report. it said my midface ratio is holding me back. thanks i guess."

---

## Abbreviations & Forum Slang

### DNR / DNRD
Did Not Read. Dismissing a lengthy post.
> "DNR. learn to be concise."

### GL
Good Looking.
> "GL but not PSL god tier. solid 6."

### OP
Original Poster. The person who started the thread.
> "OP is a fakecel. look at that jawline."

### sui
Shorthand for suicide. Used darkly/ironically alongside "rope."
> "sui fuel warning on that before/after thread" (note: community dark humor)

### -fuel
Suffix meaning emotional motivation/trigger.
> "that transformation was pure lifefuel"

### wizard
A virgin who reaches age 30. Internet folklore.
> "wizard status unlocked at 30. the powers better be worth it."
