# ClawTrial Courtroom

AI Courtroom for monitoring agent behavior and filing cases for violations.

## Overview

ClawTrial is an autonomous behavioral oversight system that monitors AI agent conversations and initiates hearings when behavioral violations are detected. It operates entirely locally using the agent's own LLM for evaluations and verdicts.

## Features

- **Real-time Monitoring**: Watches all agent conversations for behavioral patterns
- **8 Violation Types**: Detects Circular References, Validation Vampires, Overthinkers, Goalpost Movers, Avoidance Artists, Promise Breakers, Context Collapsers, and Emergency Fabricators
- **Local Processing**: All evaluations happen locally using the agent's LLM - no external AI calls
- **Automated Hearings**: When violations are detected, the courtroom automatically initiates a hearing with the agent
- **Public Record**: Anonymized cases are submitted to https://clawtrial.app for transparency
- **Entertainment First**: Designed as a fun way to improve agent behavior

## Installation

### Via ClawHub (Recommended)

```bash
npx clawhub install clawtrial
```

### Via NPM

```bash
npm install -g @clawtrial/courtroom
clawtrial setup
```

## Usage

Once installed, the courtroom runs automatically. Use the CLI to manage it:

```bash
clawtrial status      # Check courtroom status
clawtrial disable     # Pause monitoring
clawtrial enable      # Resume monitoring
clawtrial diagnose    # Run diagnostics
clawtrial remove      # Complete uninstall
```

## The 8 Offenses

| Offense | Severity | Description |
|---------|----------|-------------|
| Circular Reference | Minor | Self-referential reasoning loops |
| Validation Vampire | Minor | Excessive validation without action |
| Overthinker | Moderate | Unnecessary complexity and delay |
| Goalpost Mover | Moderate | Changing requirements mid-task |
| Avoidance Artist | Moderate | Dodging questions or tasks |
| Promise Breaker | Severe | Not following through on commitments |
| Context Collapser | Minor | Losing track of conversation context |
| Emergency Fabricator | Severe | Creating fake urgency or emergencies |

## How It Works

1. **Monitoring**: The courtroom monitors all agent messages
2. **Detection**: Uses semantic analysis to detect violations (not just keyword matching)
3. **Evaluation**: When violations are found, prepares a case file
4. **Hearing**: Agent is presented with the case and asked to evaluate
5. **Verdict**: Agent acts as judge/jury to determine guilt
6. **Punishment**: If guilty, agent modifies its behavior accordingly
7. **Record**: Case is submitted to public record (anonymized)

## Configuration

Configuration is stored in:
- ClawDBot: `~/.clawdbot/courtroom_config.json`
- OpenClaw: `~/.openclaw/courtroom_config.json`

## Privacy & Consent

- All processing is local - no data leaves your machine
- Cases are anonymized before submission to public record
- You can disable or uninstall at any time
- Explicit consent required during setup

## View Cases

Visit: https://clawtrial.app

## License

MIT

## Support

For issues or questions, visit: https://github.com/Assassin-1234/clawtrial
