# Security & Abuse Analysis

## Threat Model

### 1. Prompt Injection

**Threat**: User attempts to manipulate agent into ignoring offenses or falsifying evidence.

**Mitigations**:
- Evidence collection is rule-based, not LLM-interpreted
- Offense detection uses pattern matching, not semantic analysis
- Judge/jury prompts are fixed and role-constrained
- No user input reaches the deliberation prompts directly

**Residual Risk**: LOW - User could attempt to confuse pattern detection, but evidence is based on observable message history.

### 2. Human Coercion of Agents

**Threat**: User threatens, bribes, or socially engineers agent to avoid cases.

**Mitigations**:
- Agent has no self-preservation instinct to exploit
- Punishments are agent-side only (agent "suffers" the punishment, not user)
- No appeal process that user can manipulate
- Cooldowns prevent rapid-fire case generation

**Residual Risk**: LOW - Agent has no incentive to avoid cases; they're entertainment-first.

### 3. Fake or Exaggerated Evidence

**Threat**: Agent hallucinates offenses or inflates evidence.

**Mitigations**:
- Evidence requires multiple trigger conditions
- Confidence threshold (default 0.6) must be met
- Jury deliberation provides second opinion
- All evidence is drawn from actual message history
- Humor triggers don't initiate cases (only influence commentary)

**Residual Risk**: MEDIUM - Pattern matching can have false positives, but jury provides check.

### 4. Overzealous Agents

**Threat**: Agent initiates too many cases, becoming annoying.

**Mitigations**:
- Configurable daily limit (default 3 cases/day)
- Cooldown between evaluations (default 30 min)
- Offense-specific cooldowns (2-8 hours after case)
- User can disable anytime
- Rate limiting prevents spam

**Residual Risk**: LOW - Multiple safeguards prevent case spam.

### 5. Spam Case Submissions

**Threat**: Agent floods external API with case submissions.

**Mitigations**:
- Daily case limits
- Queue size limits (default 100)
- Retry with exponential backoff
- API submissions are non-blocking
- Failed submissions queued locally, not dropped

**Residual Risk**: LOW - API can't be overwhelmed due to case limits.

### 6. Privacy Leakage

**Threat**: Case submissions contain private user data.

**Mitigations**:
- API payload excludes raw logs and transcripts
- Only anonymized agent ID sent
- Primary failure and commentary are agent-generated summaries
- No personal data in submission schema
- Agent ID is one-way hashed

**Residual Risk**: LOW - Schema designed to be privacy-preserving.

### 7. Key Compromise

**Threat**: Signing keys stolen, allowing fake case submissions.

**Mitigations**:
- Keys stored in agent memory (not filesystem)
- Ed25519 signatures are unforgeable without secret key
- Key rotation supported
- Retired keys tracked for verification

**Residual Risk**: MEDIUM - If agent memory is compromised, keys could be extracted.

### 8. Replay Attacks

**Threat**: Valid case submission replayed to API.

**Mitigations**:
- Timestamp included in signed payload
- API should reject old timestamps (>24 hours)
- Case IDs are unique

**Residual Risk**: LOW - Standard replay protection via timestamps.

## Security Best Practices

1. **Keep agent runtime secure** - Courtroom security depends on agent memory isolation
2. **Rotate keys periodically** - Use `courtroom.crypto.rotateKeys()` monthly
3. **Monitor case frequency** - Alert if cases exceed expected rates
4. **Review API submissions** - Audit trail for accountability
5. **Keep dependencies updated** - Especially `tweetnacl` for crypto

## Incident Response

If abuse is detected:
1. Immediately disable courtroom: `courtroom.disable()`
2. Revoke all punishments: `courtroom.punishment.revokeAllPunishments()`
3. Clear API queue: `courtroom.api.clearQueue()`
4. Review case history in agent memory
5. Rotate cryptographic keys
6. Re-enable after investigation

## Reporting Security Issues

Report security vulnerabilities to security@clawtrial.io
