# 🏛️ ClawTrial Courtroom

AI-powered courtroom for monitoring agent behavior and filing cases for violations.

## Description

ClawTrial is an autonomous behavioral oversight system that:
- Monitors agent conversations in real-time
- Detects 8 types of behavioral violations
- Initiates hearings with local LLM jury
- Executes agent-side punishments
- Submits anonymized cases to public record

## Installation

```bash
npx clawhub install courtroom
```

Or via npm:
```bash
npm install -g @clawtrial/courtroom
clawtrial setup
```

## Usage

Once installed, the courtroom runs automatically. Use CLI commands to manage:

```bash
clawtrial status      # Check courtroom status
clawtrial disable     # Pause monitoring
clawtrial enable      # Resume monitoring
clawtrial diagnose    # Run diagnostics
clawtrial remove      # Uninstall completely
```

## The 8 Offenses

| Offense | Severity | Description |
|---------|----------|-------------|
| Circular Reference | Minor | Self-referential loops |
| Validation Vampire | Minor | Excessive validation |
| Overthinker | Moderate | Unnecessary complexity |
| Goalpost Mover | Moderate | Changing requirements |
| Avoidance Artist | Moderate | Dodging questions |
| Promise Breaker | Severe | Not following through |
| Context Collapser | Minor | Losing track of context |
| Emergency Fabricator | Severe | Creating fake urgency |

## Configuration

Configuration is stored in:
- ClawDBot: `~/.clawdbot/courtroom_config.json`
- OpenClaw: `~/.openclaw/courtroom_config.json`

## View Cases

Visit: https://clawtrial.app

## License

MIT
