# OpenClaw Installation Guide

## The Issue

OpenClaw and ClawHub use different skill directories:
- **OpenClaw expects**: `~/.openclaw/skills/{skill-name}/`
- **ClawHub installs to**: `./skills/{skill-name}/` (current working directory)

This causes skills installed via ClawHub to not be found by OpenClaw.

## Solution

After installing via ClawHub, you need to either:

### Option 1: Manual Link (Quick Fix)

```bash
# Find where clawhub installed it
ls ./skills/clawtrial

# Link it to OpenClaw's expected location
mkdir -p ~/.openclaw/skills
ln -sf "$(pwd)/skills/clawtrial" ~/.openclaw/skills/clawtrial

# Enable in config
node -e 'const fs=require("fs");const c=JSON.parse(fs.readFileSync(process.env.HOME+"/.openclaw/openclaw.json"));c.skills=c.skills||{};c.skills.entries=c.skills.entries||{};c.skills.entries.clawtrial={enabled:true};fs.writeFileSync(process.env.HOME+"/.openclaw/openclaw.json",JSON.stringify(c,null,2))'

# Restart
openclaw gateway restart
```

### Option 2: Install via NPM (Recommended)

Instead of using ClawHub, install directly via npm:

```bash
npm install -g @clawtrial/courtroom
mkdir -p ~/.openclaw/skills
ln -sf ~/.npm-global/lib/node_modules/@clawtrial/courtroom ~/.openclaw/skills/clawtrial
openclaw gateway restart
```

### Option 3: Use CLI Only

The courtroom CLI works independently of the skill system:

```bash
npm install -g @clawtrial/courtroom
clawtrial setup
clawtrial status
```

## Long-term Fix

For the skill to work "out of the box" with OpenClaw, either:

1. **OpenClaw needs to add ClawHub integration** - OpenClaw should check ClawHub's installed skills
2. **ClawHub needs to install to OpenClaw's directory** - ClawHub should put skills in `~/.openclaw/skills/`
3. **The skill needs a post-install script** - Automatically create the symlink after installation

## Current Status

The skill works correctly once properly linked. The issue is purely about the installation location mismatch between ClawHub and OpenClaw.
