# OpenClaw Compatibility Fix

## The Problem

OpenClaw has a **completely different skill system** than ClawDBot:

| Feature | ClawDBot | OpenClaw |
|---------|----------|----------|
| Skill Discovery | Auto-loads from `~/.clawdbot/skills/` | Uses `clawhub` registry |
| Installation | Symlink to skill directory | `npx clawhub install <slug>` |
| Format | `skill.yaml` with metadata | Published to clawhub.com |
| Bundled Skills | None | healthcheck, weather, skill-creator, clawhub |

## Why It Wasn't Working

1. OpenClaw doesn't auto-discover skills from `~/.openclaw/skills/`
2. The `skill.yaml` we created is for ClawDBot's format
3. Courtroom wasn't published to clawhub registry
4. OpenClaw's skill list only shows **bundled** or **clawhub-installed** skills

## The Solution

### Option 1: Publish to ClawHub (Recommended)

```bash
# 1. Login to clawhub
npx clawhub login

# 2. Publish the skill
cd /path/to/courtroom-package
npx clawhub publish . \
  --slug courtroom \
  --name "ClawTrial Courtroom" \
  --version 1.0.0 \
  --tags "ai,courtroom,behavior,monitoring"

# 3. Install on any machine
npx clawhub install courtroom

# 4. Restart OpenClaw
openclaw gateway restart
```

### Option 2: Create OpenClaw-Compatible Structure

OpenClaw might support local skills if we put them in the right place:

```bash
# Check where clawhub installs skills
npx clawhub list

# Install to that location
# (Usually ./skills/ or ~/.openclaw/skills/)
```

### Option 3: Use OpenClaw Plugin System

Instead of a skill, create an OpenClaw plugin:

```json
// openclaw.json
{
  "plugins": {
    "entries": {
      "courtroom": {
        "enabled": true,
        "package": "@clawtrial/courtroom"
      }
    }
  }
}
```

But this requires the package to be a valid OpenClaw plugin.

## What We Learned

From `openclaw skills` output:
- OpenClaw has 48 bundled skills
- Only 4 are "ready" (clawhub, healthcheck, skill-creator, weather)
- The rest are "missing" (need installation)
- The tip says: "use `npx clawhub` to search, install, and sync skills"

## The Real Fix

The courtroom package needs to be **published to clawhub** to work with OpenClaw.

### For Now (Temporary Workaround)

If you don't want to publish yet, you can:

1. Install via npm globally: `npm install -g @clawtrial/courtroom`
2. Use the CLI manually: `clawtrial setup && clawtrial status`
3. The skill won't show in `openclaw skills` but the CLI will work

### Long Term

Publish to clawhub so users can:
```bash
npx clawhub install courtroom
openclaw gateway restart
```

## Files That Need Updating

1. **README.md** - Add OpenClaw-specific instructions
2. **package.json** - Add clawhub metadata
3. **skill.yaml** - May need OpenClaw-specific format
4. **Publish to clawhub** - Required for proper integration

## Testing

After publishing:
```bash
# User installs
npx clawhub install courtroom

# Verify
openclaw skills
# Should show: courtroom | ClawTrial Courtroom | ✓ ready

# Restart
openclaw gateway restart

# Check status
clawtrial status
```
