# ClawHub + OpenClaw Integration Research

## Current Understanding

### The Problem
1. `npx clawhub install clawtrial` installs to `./skills/clawtrial` (current working directory)
2. OpenClaw expects skills in `~/.openclaw/skills/{skill-name}/`
3. The skill is not automatically linked/registered with OpenClaw

### What We Know Works
- **skill-creator** is a working skill published on ClawHub
- It shows in `openclaw skills` list
- It's owned by "chindden" and was created 2026-01-27

### What We Need to Find Out

#### 1. How does OpenClaw discover ClawHub-installed skills?

**Hypotheses:**
- OpenClaw scans `./skills/` directory in the current working directory
- OpenClaw has a `clawhub.lock` or similar file that tracks installed skills
- ClawHub modifies `~/.openclaw/openclaw.json` to register skills
- There's a `clawhub sync` command that updates OpenClaw's skill registry

#### 2. What is the correct skill.yaml format for OpenClaw?

**Current format:**
```yaml
name: courtroom
metadata:
  openclaw:
    emoji: "🏛️"
    autoLoad: true
    onMessage: onMessage
```

**Questions:**
- Does OpenClaw need different metadata than ClawDBot?
- Is the `install` section in skill.yaml used by OpenClaw?
- Does OpenClaw need a specific `source` or `kind` field?

#### 3. Where does ClawHub actually install skills?

**Evidence:**
- `npx clawhub list` shows `clawtrial 1.0.5` is installed
- But `~/.openclaw/skills/` is EMPTY
- `./skills/` directory doesn't exist in current working directory

**Hypotheses:**
- ClawHub installs to a global location we haven't found yet
- ClawHub installs to `~/.clawhub/skills/` (doesn't exist)
- ClawHub installs to the current working directory's `./skills/`
- The skill is only in the registry, not actually downloaded

#### 4. How do bundled skills work vs ClawHub skills?

**Bundled skills** (like healthcheck, weather):
- Located in OpenClaw's package: `openclaw/skills/`
- Show as "✓ ready" in `openclaw skills`

**ClawHub skills** (like skill-creator, clawtrial):
- Show in `npx clawhub list`
- May not show in `openclaw skills` until properly linked

### Research Tasks

1. **Find where ClawHub installs skills**
   ```bash
   find ~ -type d -name "clawtrial" 2>/dev/null
   find ~ -name "clawhub.lock" 2>/dev/null
   ls -la ~/.clawhub/ 2>/dev/null
   ```

2. **Check if OpenClaw has ClawHub integration config**
   ```bash
   cat ~/.openclaw/openclaw.json | grep -i clawhub
   ```

3. **Compare working skill (skill-creator) with our skill**
   - Download skill-creator files
   - Compare skill.yaml structure
   - Compare _meta.json structure

4. **Test clawhub sync command**
   ```bash
   npx clawhub sync --dry-run
   ```

5. **Check OpenClaw documentation**
   - Look for skill installation docs
   - Look for ClawHub integration docs

### Potential Solutions

#### Option 1: Post-install Hook (Current Approach)
Add a post-install script that:
- Detects OpenClaw
- Creates symlink in `~/.openclaw/skills/`
- Updates OpenClaw config

**Pros:** Works immediately
**Cons:** Requires npm install, not clawhub install

#### Option 2: ClawHub Install Location
Figure out where ClawHub installs skills and:
- Make OpenClaw scan that location
- Or create a symlink from ClawHub location to OpenClaw location

**Pros:** Uses proper ClawHub workflow
**Cons:** Need to understand ClawHub's install mechanism

#### Option 3: OpenClaw Plugin Instead of Skill
Convert from skill to plugin:
- Plugins go in `~/.openclaw/plugins/`
- Different structure than skills
- May have better integration

**Pros:** Might be more appropriate for this use case
**Cons:** Requires significant restructuring

#### Option 4: ClawHub + OpenClaw Native Integration
Wait for or request official integration between ClawHub and OpenClaw.

**Pros:** Proper long-term solution
**Cons:** Not available now

### Next Steps

1. Run diagnostic commands on OpenClaw machine to find where ClawHub installed the skill
2. Compare skill-creator's structure with our skill
3. Test if `clawhub sync` makes the skill visible to OpenClaw
4. If all else fails, document the npm install approach as the recommended method

### Questions for OpenClaw/ClawHub Team

1. How does OpenClaw discover skills installed via ClawHub?
2. What is the correct skill.yaml format for OpenClaw compatibility?
3. Should skills be installed via `clawhub install` or `npm install` for OpenClaw?
4. Is there a plan for better ClawHub/OpenClaw integration?
