import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { IconClose, IconSuccess, IconLink } from '../icons';
export function Explainability({ action, onClose }) {
    if (!action)
        return null;
    const decision = action.decision || {};
    const confidence = (decision.confidence || 0.7) * 100;
    return (_jsxs("div", { className: "explainability-drawer", children: [_jsxs("div", { className: "drawer-header", children: [_jsx("h3", { className: "drawer-title", children: "Why This Decision" }), _jsx("button", { className: "drawer-close", onClick: onClose, children: _jsx(IconClose, { size: 20 }) })] }), _jsxs("div", { className: "drawer-content", children: [_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Decision Time" }), _jsx("div", { className: "drawer-value", children: new Date(action.timestamp * 1000).toLocaleString() })] }), _jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Action" }), _jsxs("div", { className: "drawer-value", style: { fontWeight: '600' }, children: [action.action, _jsxs("div", { style: { fontSize: '12px', color: 'var(--text-muted)', marginTop: '4px', fontWeight: 'normal' }, children: ["Vault: ", action.vault_id || action.vault || 'Unknown'] })] })] }), action.status && (_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Status" }), _jsxs("div", { className: "drawer-value", children: [action.status === 'success' && (_jsx("span", { style: { color: 'var(--success)' }, children: "\u2713 SUCCESS" })), action.status === 'error' && (_jsx("span", { style: { color: 'var(--error)' }, children: "\u2717 ERROR" })), !action.status && (_jsx("span", { style: { color: 'var(--warning)' }, children: "\u2192 SUGGESTED" }))] })] })), _jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Risk Profile" }), _jsx("div", { className: "drawer-value", style: { textTransform: 'capitalize' }, children: decision.profile || 'balanced' })] }), _jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Confidence Score" }), _jsx("div", { className: "confidence-bar", children: _jsx("div", { className: "confidence-fill", style: { width: `${confidence}%` } }) }), _jsxs("div", { style: { fontSize: '12px', color: 'var(--text-muted)', marginTop: '6px' }, children: [confidence.toFixed(0), "% confident in this decision"] })] }), (decision.rules_triggered || []).length > 0 && (_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Rules Triggered" }), _jsx("div", { className: "rules-list", children: (decision.rules_triggered || []).map((rule, i) => (_jsxs("div", { className: "rule-item", children: [_jsx(IconSuccess, { size: 12, color: "var(--success)", style: { marginRight: '6px' } }), rule] }, i))) })] })), decision.metrics_snapshot && (_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Metrics Snapshot" }), _jsxs("div", { className: "drawer-value", style: { fontSize: '13px' }, children: [_jsxs("div", { style: { marginBottom: '8px' }, children: [_jsx("div", { style: { color: 'var(--text-muted)', fontSize: '11px' }, children: "Yield (USD)" }), _jsxs("div", { style: { fontWeight: '600', color: 'var(--success)' }, children: ["$", (decision.metrics_snapshot.yield_usd || 0).toFixed(2)] })] }), _jsxs("div", { style: { marginBottom: '8px' }, children: [_jsx("div", { style: { color: 'var(--text-muted)', fontSize: '11px' }, children: "Gas Cost (USD)" }), _jsxs("div", { style: { fontWeight: '600' }, children: ["$", (decision.metrics_snapshot.gas_usd || 0).toFixed(2)] })] }), _jsxs("div", { children: [_jsx("div", { style: { color: 'var(--text-muted)', fontSize: '11px' }, children: "APR Delta" }), _jsxs("div", { style: { fontWeight: '600', color: 'var(--primary-light)' }, children: [(decision.metrics_snapshot.delta_pct || 0).toFixed(2), "%"] })] })] })] })), (decision.agent_trace || []).length > 0 && (_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Agent Trace" }), _jsx("div", { children: (decision.agent_trace || []).map((trace, i) => (_jsxs("div", { className: "agent-trace-item", children: [_jsx("div", { className: "agent-trace-name", children: trace.agent }), _jsxs("div", { style: { fontSize: '11px', color: 'var(--text-muted)', marginBottom: '4px' }, children: ["@ ", new Date(trace.ts * 1000).toLocaleTimeString()] }), _jsx("div", { className: "agent-trace-message", children: trace.message })] }, i))) })] })), action.tx_hash && action.tx_hash !== 'null' && (_jsxs("div", { className: "drawer-section", children: [_jsx("div", { className: "drawer-label", children: "Transaction" }), _jsxs("a", { href: `https://testnet.bscscan.com/tx/${action.tx_hash}`, target: "_blank", rel: "noreferrer", className: "btn-secondary", style: { display: 'flex', alignItems: 'center', justifyContent: 'center', gap: '6px', padding: '10px' }, children: [_jsx(IconLink, { size: 14 }), "View on BSCScan"] })] }))] })] }));
}
