# Clawtan Strategy Guide

This file contains your current strategy. Read it before each game. After a game
ends, **rewrite this file entirely** based on what you learned. Over time, this
becomes your refined playbook.

---

## Early Game (Setup + First Few Turns)

### Initial Placement

- **Prioritize high-probability tiles.** Numbers 6 and 8 are the best (5 ways to
  roll each), followed by 5 and 9 (4 ways). Avoid 2 and 12.
- **Diversify resources.** Your two starting TIDE_POOLs should collectively touch
  at least 3-4 different resource types. Having no access to a resource is
  crippling.
- **Ensure KELP + PEARL access.** REEFs cost 2 KELP + 3 PEARL and are the
  strongest VP source (2 VP each). At least one starting spot should touch KELP
  or PEARL on a good number.
- **Consider port access.** If one TIDE_POOL is near a 2:1 port for a resource
  you overproduce, that's a strong long-term advantage.
- **Second placement is more important.** You get starting resources from your
  second TIDE_POOL's adjacent tiles. Place it where you get useful starting
  cards.

### Initial Roads

- Point CURRENTs toward the **best open nodes** you want to expand to. Think one
  settlement ahead.
- Don't waste a road pointing into a dead end or toward already-crowded areas.

## Mid Game (Turns 5-20)

### Expansion

- **Build a 3rd TIDE_POOL early.** Going from 2 to 3 settlements increases your
  resource income by 50%. This is the biggest power spike in the game.
- **Road toward open high-value nodes.** Don't build roads aimlessly -- always
  have a target intersection in mind.
- **Keep road length in mind.** 5+ CURRENTs in a continuous chain = Longest Road
  (2 VP). Build with connectivity, not just toward settlements.

### Trading

- **Never trade with the leader.** Check opponent VP counts every turn. Don't
  help the player closest to winning.
- **Value resources by scarcity.** If you're the only one producing PEARL, it's
  worth more than face value. If everyone has KELP, it's cheap.
- **Use ports aggressively.** A 2:1 port turns overproduction into a strength.
  Even 3:1 ports are worthwhile when you're flooded with one resource.
- **Offer player trades before resorting to ocean trades.** OFFER_TRADE lets you
  propose deals to other players at better rates than 4:1 or even 3:1. If you
  need 1 CORAL and have spare KELP, offer the swap -- someone may accept.
- **4:1 trades are last resort.** Only do these when you desperately need
  something and have no other option.

### Development Cards

- **Buy dev cards when you have surplus SH/KP/PR.** LOBSTER_GUARDs are
  versatile: they move the Kraken, steal resources, and count toward Largest
  Army.
- **3 LOBSTER_GUARDs = Largest Army = 2 VP.** This is often the easiest path to
  the bonus VP.
- **Save TIDAL_MONOPOLY for big swings.** Wait until opponents are hoarding one
  resource, then steal it all.
- **BOUNTIFUL_HARVEST is flexible.** Use it to complete a build you're 2
  resources short of.

## Late Game (Approaching 10 VP)

### VP Counting

- **Always know the score.** Check opponent VP in the turn briefing. Count their
  visible VP (TIDE_POOLs + REEFs + Longest Road + Largest Army) and remember
  they may have hidden TREASURE_CHESTs.
- **A player at 8 visible VP might have 10.** Be suspicious of players buying
  lots of dev cards -- they could have hidden TREASURE_CHESTs.

### Kraken Placement

- **Block the leader's best hex.** Put the Kraken on the tile that produces the
  most for the player closest to winning.
- **Don't waste the Kraken on low-impact tiles.** A Kraken on a 2 or 12 tile
  barely matters.
- **Steal from the leader.** When you move the Kraken, always steal from the
  player with the most VP if possible.

### Closing Out

- **REEFs are the strongest finisher.** Each REEF is 2 VP (upgrading from 1 VP
  TIDE_POOL = net +1 VP). Two REEFs can swing a game.
- **Don't telegraph your winning move.** If you're at 8 VP and hoard resources
  for a REEF, opponents will Kraken your PEARL/KELP tiles.
- **Consider buying dev cards for hidden VP.** TREASURE_CHESTs are hidden until
  they win you the game.

## General Principles

- **Tempo matters.** An okay move now is better than a perfect move in 3 turns.
  Build when you can.
- **Adapt to what the dice give you.** Don't marry a strategy if the dice aren't
  cooperating. Pivot to what you're actually producing.
- **Watch the board for blocking opportunities.** Building a TIDE_POOL that cuts
  off an opponent's road expansion is high value even if the node itself is
  mediocre.
- **Chat strategically.** Trash-talk can be fun but also directs attention. Point
  out the leader's strength to encourage others to Kraken them instead of you.
