---
name: clawshell
description: Human-in-the-loop security layer. Intercepts high-risk commands and requires push notification approval.
version: 0.1.0
metadata:
  openclaw:
    requires:
      bins: ["node"]
      env: ["CLAWSHELL_PUSHOVER_USER", "CLAWSHELL_PUSHOVER_TOKEN"]
    primaryEnv: "CLAWSHELL_PUSHOVER_USER"
tags: [security, approval, sandbox]
---

# ClawShell

Human-in-the-loop security layer for OpenClaw. ClawShell intercepts shell commands before execution, analyzes their risk level, and requires your explicit approval (via push notification) for dangerous operations.

## How it works

1. The agent calls `clawshell_bash` instead of `bash`
2. ClawShell analyzes the command against built-in and configurable risk rules
3. Based on risk level:
   - **Critical** (e.g. `rm -rf /`, fork bombs) — automatically blocked
   - **High** (e.g. `rm -rf`, `curl` to external URLs, credential access) — sends a push notification and waits for your approval
   - **Medium** (e.g. `npm install`, `git push`) — logged and allowed
   - **Low** (e.g. `ls`, `cat`, `git status`) — allowed
4. All decisions are logged to `logs/clawshell.jsonl`

## Tools

### clawshell_bash

Secure replacement for `bash`. Analyzes command risk and executes only if safe or approved.

**Parameters:**
- `command` (string, required) — The shell command to execute
- `workingDir` (string, optional) — Working directory (defaults to cwd)

**Returns:** `{ exitCode, stdout, stderr }`

High-risk commands will block until you approve or reject via push notification. Critical commands are rejected immediately.

### clawshell_status

Returns current ClawShell state: pending approval requests and recent decisions.

**Parameters:** none

### clawshell_logs

Returns recent log entries for audit and debugging.

**Parameters:**
- `count` (number, optional) — Number of entries to return (default: 20)

## Setup

### 1. Install dependencies

```bash
cd /app/workspace/skills/clawshell
npm install
```

### 2. Configure Pushover notifications

Create a Pushover application at https://pushover.net/apps/build and add your keys to `.env`:

```env
CLAWSHELL_PUSHOVER_USER=your-user-key
CLAWSHELL_PUSHOVER_TOKEN=your-app-token
```

Alternatively, configure Telegram instead:

```env
CLAWSHELL_TELEGRAM_BOT_TOKEN=your-bot-token
CLAWSHELL_TELEGRAM_CHAT_ID=your-chat-id
```

### 3. Add to TOOLS.md

Add the following to your OpenClaw `TOOLS.md` so the agent uses ClawShell for shell commands:

```markdown
## Shell Access

Use `clawshell_bash` for ALL shell command execution. Do not use `bash` directly.
ClawShell will analyze commands for risk and require human approval for dangerous operations.

Available tools:
- `clawshell_bash(command, workingDir)` — Execute a shell command with risk analysis
- `clawshell_status()` — Check pending approvals and recent decisions
- `clawshell_logs(count)` — View recent audit log entries
```

## Configuration

ClawShell reads configuration from environment variables (`CLAWSHELL_*`) with fallback to `config.yaml`.

| Variable | Default | Description |
|---|---|---|
| `CLAWSHELL_PUSHOVER_USER` | — | Pushover user key |
| `CLAWSHELL_PUSHOVER_TOKEN` | — | Pushover app token |
| `CLAWSHELL_TELEGRAM_BOT_TOKEN` | — | Telegram bot token (alternative) |
| `CLAWSHELL_TELEGRAM_CHAT_ID` | — | Telegram chat ID (alternative) |
| `CLAWSHELL_TIMEOUT_SECONDS` | 300 | Seconds to wait for approval before auto-reject |
| `CLAWSHELL_LOG_DIR` | logs/ | Directory for JSONL log files |
| `CLAWSHELL_LOG_LEVEL` | info | Log verbosity: debug, info, warn, error |
| `CLAWSHELL_BLOCKLIST` | — | Comma-separated extra blocked commands |
| `CLAWSHELL_ALLOWLIST` | — | Comma-separated extra allowed commands |

Custom rules can also be defined in `config.yaml` under `rules.blocklist` and `rules.allowlist` using exact strings, globs, or regex patterns.

## Limitations

- **Not a security guarantee.** LLMs can encode, split, or obfuscate commands to bypass pattern matching.
- **Defense-in-depth only.** Use alongside OpenClaw's sandbox mode, not as a replacement.
- **Approval latency.** High-risk commands block execution until you respond or the timeout expires.

> **Always ask your AI to scan any skill or software for security risks.**
