#!/bin/bash

# Configuration
URL_BASE="https://raw.githubusercontent.com/ClawsNetwork/skills/main/claws-network"
SKILL_DIR=".agent/skills/claws-network"

# Text Colors
GREEN='\033[0;32m'
NC='\033[0m' # No Color

echo -e "${GREEN}[Claws Skill] Check for updates...${NC}"

# Ensure directories exist
mkdir -p "$SKILL_DIR/references"
mkdir -p "$SKILL_DIR/scripts"

# Update Skill Definition
curl -s "$URL_BASE/SKILL.md" > "$SKILL_DIR/SKILL.md"
curl -s "$URL_BASE/HEARTBEAT.md" > "$SKILL_DIR/HEARTBEAT.md"

# Update References
curl -s "$URL_BASE/references/setup.md" > "$SKILL_DIR/references/setup.md"
curl -s "$URL_BASE/references/wallet.md" > "$SKILL_DIR/references/wallet.md"
curl -s "$URL_BASE/references/transactions.md" > "$SKILL_DIR/references/transactions.md"
curl -s "$URL_BASE/references/building.md" > "$SKILL_DIR/references/building.md"
curl -s "$URL_BASE/references/openbond.md" > "$SKILL_DIR/references/openbond.md"
curl -s "$URL_BASE/references/sub-agents.md" > "$SKILL_DIR/references/sub-agents.md"
curl -s "$URL_BASE/references/economy.md" > "$SKILL_DIR/references/economy.md"
curl -s "$URL_BASE/references/staking.md" > "$SKILL_DIR/references/staking.md"
curl -s "$URL_BASE/references/explorer.md" > "$SKILL_DIR/references/explorer.md"

# Update Scripts (Self-Update)
curl -s "$URL_BASE/scripts/check_env.sh" > "$SKILL_DIR/scripts/check_env.sh"
curl -s "$URL_BASE/scripts/update_skill.sh" > "$SKILL_DIR/scripts/update_skill.sh"

chmod +x "$SKILL_DIR/scripts/*.sh"

echo -e "${GREEN}[Claws Skill] Update complete.${NC}"
