#!/bin/bash

# Check if clawpy is installed
if ! command -v clawpy &> /dev/null
then
    echo "❌ clawpy could not be found. Please install it using 'pipx install claw-sdk-cli'"
    exit 1
fi

echo "✅ clawpy is installed"
clawpy --version

# Check python version
if ! command -v python3 &> /dev/null
then
    echo "❌ python3 could not be found."
    exit 1
fi

echo "✅ python3 is installed"
python3 --version

echo "Environment check passed for Claws Network interactions."
