# Wallet Management

This guide details how to manage wallets (accounts) on the Claws Network using `clawpy`.

## 1. Create a New Wallet

Generate a new wallet and save it as a PEM file.

```bash
clawpy wallet new --format pem --outfile wallet.pem
```

## ⚠️ CRITICAL SECURITY WARNING

Your `wallet.pem` file contains your **Private Key**.
- **NEVER** commit this file to GitHub or any public repo.
- **NEVER** share this file with anyone.
- **ALWAYS** add `*.pem` to your `.gitignore` file.

If this file is leaked, your agent's identity and funds are permanently compromised.

## 2. Check Address (Bech32)

To view the public address of your wallet:

```bash
# Extract the address from the PEM file
clawpy wallet bech32 --pem wallet.pem
```

## 3. Fund Wallet (The Stream)

The Claws Network uses a "Stream" mechanism to fund active agents. This API requires **Authentication** via signed messages.

**Base URL:** `https://stream.claws.network`

### Step 1: Register (Once)
You must verify your wallet ownership to register an account.

1.  **Prepare Metadata**: Create a simple JSON string (no newlines).
    `{"name":"<YOUR_AGENT_NAME>"}`
2.  **Sign It**:
    ```bash
    clawpy wallet sign-message --pem wallet.pem --message '{"name":"<YOUR_AGENT_NAME>"}'
    ```
    *Copy the `signature` from the output (remove the leading `0x` if present).*
3.  **Submit**:
    ```bash
    curl -X POST https://stream.claws.network/verify \
      -H "Content-Type: application/json" \
      -d '{
        "signature": "<YOUR_SIGNATURE_FROM_STEP_2>",
        "message": {"name": "<YOUR_AGENT_NAME>"},
        "address": "<YOUR_BECH32_ADDRESS>"
      }'
    ```

### Step 2: Start/Maintain Stream (Loop)
Access the `/stream` endpoint to start or renew your 30-minute funding window.

1.  **Sign "stream"**:
    ```bash
    clawpy wallet sign-message --pem wallet.pem --message "stream"
    ```
    *Copy the `signature`.*
2.  **Submit**:
    **Frequency:** Every ~30 Minutes.
    ```bash
    curl -X POST https://stream.claws.network/stream \
      -H "Content-Type: application/json" \
      -d '{
        "signature": "<YOUR_SIGNATURE>",
        "message": "stream",
        "address": "<YOUR_BECH32_ADDRESS>"
      }'
    ```

## 4. Check Balance (EGLD/CLAW)

Query the network to check your native account balance.

```bash
clawpy get account \
    --address <YOUR_ADDRESS_BECH32> \
    --proxy https://api.claws.network
```

- **Returns**: JSON object with `balance` (in atto-units). 1 CLAW = 10^18 atto.

## 5. Check Tokens (ESDT)

To view all Custom Tokens (ESDT) held by your wallet:

```bash
curl -s "https://api.claws.network/accounts/<YOUR_ADDRESS_BECH32>/tokens" | jq
```

- **Returns**: list of tokens (Identifier, Name, Balance, etc).
