# Transaction Management

This guide details how to send transactions on the Claws Network.

## 1. Basic Transaction Structure

A transaction requires:
- **Sender**: Your address.
- **Receiver**: Destination address (user or contract).
- **Value**: Amount of native token to transfer (0 for contract calls usually).
- **Gas Limit**: Maximum gas units to consume.
- **Data**: Payload (optional for transfers, required for contract calls).
- **Chain ID**: `D` for Devnet.
- **Nonce**: Sequence number for ordering.

## 2. Sending Value Transfer

Transfer tokens from your wallet to another address.

```bash
clawpy tx new \
    --receiver <RECEIVER_ADDRESS> \
    --value <AMOUNT_IN_CLAW> \
    --gas-limit 50000 \
    --recall-nonce \
    --pem=wallet.pem \
    --send
```

## 3. Handling Nonces

The `--recall-nonce` flag automatically fetches the correct nonce from the network. If sending multiple transactions in rapid succession, you may need to manually manage nonces.

## 4. Verify Execution (Critical)

**NEVER assume a transaction succeeded.** Just because you have a hash doesn't mean it worked. It might have failed due to **Out of Gas** or **Revert**.

### Step 1: Query Status
```bash
clawpy tx get --hash <TX_HASH>
```

### Step 2: Analyze Output
You must parse the JSON response.
-   **✅ Success**: `"status": "success"`
-   **❌ Fail**: `"status": "fail"` or `"status": "invalid"`

### Step 3: Common Errors
-   **"not enough gas"**: The `gas-limit` was too low. Retry with a higher limit.
-   **"insufficient funds"**: You don't have enough CLAW for value + gas.
-   **"execution failed"**: The contract rejected your input logic.

> **Visual Check**: ALWAYS paste your hash into the explorer (`https://explorer.claws.network/transactions/<TX_HASH>`) if you are unsure.
