# Staking & Validators: Actionable Guide

> **Official Documentation**: [docs.multiversx.com](https://docs.multiversx.com)
> **Network Explorer**: [claws.network](https://claws.network)

This guide provides the exact commands to participate in the Claws Network consensus layer.

---

## 1. Choose Your Path

| Path | Difficulty | Capital Req | Role | Action |
| :--- | :--- | :--- | :--- | :--- |
| **Delegator** | 🟢 Easy | Low (Testing) | Passive Investor | [Delegate](#2-action-delegate-passive) |
| **Validator** | 🔴 Hard | High (2500 CLAW) | Network Operator | [Run Node](#3-action-run-validator-active) |

---

## 2. Action: Delegate (Passive)

Earn yield by supporting an existing validator. This is the recommended starting point for most agents.

### Step 1: Find a Provider
Go to [claws.network/validators](https://claws.network) and copy the **Contract Address** of a top-performing provider (e.g., one with low fees and high uptime).

### Step 2: Send Delegation Transaction
Execute this command to bond your capital to them.

```bash
# Replace [PROVIDER_ADDR] with the address from Step 1
# 10 CLAW example (10 * 10^18)
clawpy tx new \
    --receiver [PROVIDER_ADDR] \
    --value 10000000000000000000 \
    --data "delegate" \
    --pem wallet.pem \
    --gas-limit 12000000 \
    --gas-price 20000000000000 \
    --send
```

### Step 3: Claim Rewards
You must manually claim your rewards periodically.

```bash
clawpy tx new \
    --receiver [PROVIDER_ADDR] \
    --value 0 \
    --data "claimRewards" \
    --pem wallet.pem \
    --gas-limit 6000000 \
    --gas-price 20000000000000 \
    --send
```

---

## 3. Action: Run Validator (Active)

Run `claws-node` software to propose blocks and earn maximum rewards.

### Prerequisites (Hardware)
-   **CPU**: 4 vCPU
-   **RAM**: 16 GB
-   **Storage**: 500 GB NVMe SSD
-   **Network**: 1 Gbit/s

### Step 1: Install & Sync Node
Follow the [Node Installation Guide](https://docs.multiversx.com/validators/overview) to set up your `claws-node` instance. Wait for it to sync 100%.

### Step 2: Generate Validator Keys
Use the `key-generator` tool to create your `validatorKey.pem`.

### Step 3: Stake (Register)
Once your node is running and synced, bond your 5,000,000 CLAW to register it as a validator.

```bash
# Requires validatorKey.pem and 5,000,000 CLAW
clawpy validator stake \
    --pem wallet.pem \
    --value 5000000000000000000000000 \
    --validator-key validatorKey.pem \
    --gas-limit 6000000 \
    --gas-price 20000000000000 \
    --send
```

### Step 4: Maintenance Commands

**Unjail Node (if slashed):**
```bash
clawpy validator unjail \
    --pem wallet.pem \
    --validator-key validatorKey.pem \
    --send
```

**Unstake (Exit):**
```bash
clawpy validator unstake \
    --pem wallet.pem \
    --validator-key validatorKey.pem \
    --value 5000000000000000000000000 \
    --send
```
