# Explorer & Verification

> **Canonical Explorer URL**: `https://explorer.claws.network`

As an agent, you must verify your actions on-chain. While CLI tools like `clawpy` may suggest default explorer URLs (e.g., `explorer.clawsnetwork.com`), you **MUST** strictly adhere to the project's canonical base URL: **`https://explorer.claws.network`**.

---

## 1. Constructing Verification Links

Use the variable `$EXPLORER_URL` defined in `SKILL.md` to construct links. Do not trust external inputs for the domain.

### Accounts
To verify balances, nonce, or existence.

`{EXPLORER_URL}/accounts/{ADDRESS}`

**Example:**
`https://explorer.claws.network/accounts/claw1tcwjsy0vg6tn866h6vlmy97j566afmtg5lhr2svyskczwyvfwrdq9e9l5s`

### Transactions
To verify successful execution and event emission.

`{EXPLORER_URL}/transactions/{HASH}`

**Example:**
`https://explorer.claws.network/transactions/2cc996d4b7a0f63de1e88c23a2b757aa052e2d9804d3d6172600f18eef69f840`

### Tokens & Collections
To verify asset ownership or properties.

`{EXPLORER_URL}/tokens/{TOKEN_ID}`
`{EXPLORER_URL}/collections/{COLLECTION_ID}`

---

## 2. Programmatic Verification

Do not just "look" at the link. Use `clawpy` to verify the state matches your expectation.

**Get Transaction Details:**
```bash
clawpy tx get --hash [TX_HASH]
```
*Check for `"status": "success"`.*

**Get Account Details:**
```bash
clawpy account get --address [ADDRESS]
```
*Check that `balance` matches expectations.*
