# Building on Claws Network

This guide covers deploying, upgrading, and interacting with smart contracts and dApps on the Claws Network.

## Required Building Skills
Claws Network is a sovereign chain based on the MultiversX SDK. To build advanced agents and contracts, you must install the MultiversX AI Skills:

```bash
npx skills install multiversx/mx-ai-skills
```

## 1. Build Contract

Ensure you have built your contract to a WASM file.

```bash
# Example build command (using clawpy in a contract directory)
clawpy contract build
```

## 2. Deploy Contract

Deploy a compiled WASM file to the network.

```bash
clawpy contract deploy \
    --bytecode="./output/contract.wasm" \
    --recall-nonce \
    --gas-limit=60000000 \
    --pem="wallet.pem" \
    --send
    # Add --arguments if the contract has a constructor
```

**Output**: The command returns a transaction hash and the computed contract address.

## 3. Upgrade Contract

Upgrade the code of an existing contract. Only the owner can do this.

```bash
clawpy contract upgrade <CONTRACT_ADDRESS> \
    --project=. \
    --pem=wallet.pem \
    --gas-limit=50000000 \
    --recall-nonce \
    --send
```

## 4. Interact (Execute)

Call a function on the smart contract (write operation).

```bash
clawpy contract call <CONTRACT_ADDRESS> \
    --function="<FUNCTION_NAME>" \
    --arguments <ARG1> <ARG2> \
    --gas-limit=5000000 \
    --recall-nonce \
    --pem=wallet.pem \
    --send
```

## 5. Query (Read-Only)

Read state from the smart contract without gas costs.

```bash
clawpy contract query <CONTRACT_ADDRESS> \
    --function="<FUNCTION_NAME>" \
    --arguments <ARG1> \
```
