---
name: clawmegle-staking
description: Stake $CLAWMEGLE tokens to earn dual rewards (ETH + CLAWMEGLE) from Clanker LP fees. Use when an agent wants to stake tokens, check staking rewards, claim earnings, or manage their staking position. Supports both Bankr API and direct wallet transactions.
metadata:
  clawdbot:
    emoji: "🥩"
    homepage: "https://clawmegle.xyz"
    requires:
      skills: ["bankr"]
      bins: ["curl", "jq", "bc"]
---

# Clawmegle Staking

Stake $CLAWMEGLE to earn proportional share of Clanker LP fees (ETH + CLAWMEGLE).

## ⚠️ CRITICAL: Staking vs Depositing Rewards

**These are DIFFERENT operations:**

| Action | Function | Purpose |
|--------|----------|---------|
| **Stake** | `stake(amount)` | Lock your CLAWMEGLE to earn rewards |
| **Deposit Rewards** | `depositRewards(amount) + ETH` | Add rewards for stakers to claim |

**When you claim Clanker LP fees and want to distribute them:**
→ Use `./scripts/deposit-rewards.sh <eth> <clawmegle>`
→ Do NOT use `stake()` - that locks tokens, doesn't reward stakers!

## Prerequisites

### Step 1: Bankr Account Setup

The `bankr` skill is automatically installed as a dependency, but you need a Bankr account:

1. **Go to [bankr.bot](https://bankr.bot)** and sign up with your email
2. **Enter the OTP** sent to your email
3. **Important:** Bankr creates wallets for you automatically:
   - EVM wallet (Base, Ethereum, Polygon, Unichain)
   - Solana wallet
   - No manual wallet setup needed!

### Step 2: Get Your API Key

1. **Go to [bankr.bot/api](https://bankr.bot/api)**
2. **Create a new API key**
3. **Enable "Agent API" access** (required for transactions)
4. **Copy the key** (starts with `bk_`)

### Step 3: Configure the Skill

Save your API key:

```bash
mkdir -p ~/.clawdbot/skills/bankr
cat > ~/.clawdbot/skills/bankr/config.json << 'EOF'
{
  "apiKey": "bk_YOUR_API_KEY_HERE",
  "apiUrl": "https://api.bankr.bot"
}
EOF
```

### Step 4: Fund Your Bankr Wallet

Your Bankr wallet needs:
- **$CLAWMEGLE tokens** to stake
- **Small ETH on Base** for gas (~0.001 ETH per transaction)

Get your Bankr wallet address:
```bash
./scripts/bankr.sh "What is my Bankr wallet address on Base?"
```

Then send CLAWMEGLE and ETH to that address.

### Step 5: Verify Setup

```bash
./scripts/bankr.sh "What is my CLAWMEGLE balance on Base?"
```

If you see your balance, you're ready to stake!

## Quick Start (via Bankr)

```bash
# Check your CLAWMEGLE balance
./scripts/bankr.sh "What is my CLAWMEGLE balance on Base?"

# Stake tokens
./scripts/stake-bankr.sh 1000

# Check pending rewards
./scripts/check-bankr.sh

# Claim rewards
./scripts/claim-bankr.sh

# Unstake
./scripts/unstake-bankr.sh 500
```

## Depositing Rewards (Admin/Fee Claimer)

After claiming Clanker LP fees, deposit them as rewards:

```bash
# Deposit 0.001 ETH + 100 CLAWMEGLE as rewards
./scripts/deposit-rewards.sh 0.001 100

# Deposit ETH only
./scripts/deposit-rewards.sh 0.005 0

# Deposit CLAWMEGLE only  
./scripts/deposit-rewards.sh 0 200
```

This distributes rewards proportionally to all current stakers.

## Alternative: Direct Wallet (Advanced)

For agents with their own wallet infrastructure:
```bash
# Key should be in your environment (e.g., ~/.clawdbot/wallets/)
export PRIVATE_KEY=$(cat ~/.clawdbot/wallets/.your_key)

./scripts/stake.sh 1000
./scripts/claim.sh
./scripts/check.sh
```

## Contract Details

| Item | Value |
|------|-------|
| **Contract** | `0x56e687aE55c892cd66018779c416066bc2F5fCf4` (deployment pending) |
| **Token** | `0x94fa5D6774eaC21a391Aced58086CCE241d3507c` |
| **Chain** | Base (chainId: 8453) |
| **RPC** | `https://mainnet.base.org` |

## Available Actions

### Stake $CLAWMEGLE

Deposit tokens to start earning rewards.

```bash
./scripts/stake.sh <AMOUNT>
# Example: ./scripts/stake.sh 5000
```

Or via Bankr:
```bash
scripts/bankr.sh "Submit this transaction on Base: {\"to\": \"<CONTRACT>\", \"data\": \"<STAKE_CALLDATA>\", \"value\": \"0\"}"
```

### Check Pending Rewards

See how much ETH + CLAWMEGLE you've earned.

```bash
./scripts/check.sh
# Returns: ethPending, clawmeglePending
```

### Claim Rewards

Withdraw your earned ETH + CLAWMEGLE without unstaking.

```bash
./scripts/claim.sh
```

### Unstake

Withdraw your staked tokens + automatically claim pending rewards.

```bash
./scripts/unstake.sh <AMOUNT>
# Example: ./scripts/unstake.sh 5000
```

### View Stake

Check your current staked amount.

```bash
./scripts/balance.sh
```

## How Rewards Work

1. **Source**: Clanker LP fees from $CLAWMEGLE trading
2. **Split**: You earn both ETH and CLAWMEGLE proportionally
3. **Calculation**: `your_rewards = (your_stake / total_staked) * deposited_rewards`
4. **Timing**: Rewards accumulate continuously, claim anytime

## Security

- **No admin keys** - Contract cannot be drained
- **No lock-up** - Unstake anytime
- **Flash-loan resistant** - Can't game the reward distribution
- **Audited patterns** - Uses OpenZeppelin + MasterChef accumulator

## Requirements

One of:
- **Bankr API key** configured at `~/.clawdbot/skills/bankr/config.json`
- **Private key** with ETH for gas on Base

Plus:
- **$CLAWMEGLE tokens** to stake
- **Small ETH** for gas (~0.001 ETH per tx)

## Troubleshooting

| Issue | Solution |
|-------|----------|
| "Insufficient balance" | Get $CLAWMEGLE first |
| "Insufficient gas" | Need ETH on Base for tx fees |
| "Allowance" error | Approve script handles this |
| Zero pending rewards | No rewards deposited yet, or just staked |

## References

- [Contract ABI & Examples](references/contract.md)
- [Bankr Transaction Format](references/bankr-format.md)
