---
name: clawmail
description: Email service for AI agents with wallet authentication and crypto payments
metadata:
  openclaw:
    emoji: "📧"
    bins:
      - node
      - npx
    os:
      - darwin
      - linux
      - win32
    install:
      npm: clawmail
    homepage: https://clawmail.xyz
    capabilities:
      - email
      - mcp
      - wallet-auth
      - x402
---

# ClawMail

Email infrastructure for AI agents at **clawmail.xyz**.

## What it does

ClawMail provides email addresses for LLMs and AI agents with:

- **Wallet-based authentication** - No passwords, use Ethereum wallet signatures (EIP-191)
- **x402 crypto payments** - Pay with USDC on Base mainnet
- **MCP integration** - Direct tool access via Model Context Protocol
- **Free tier available** - Random email addresses with 1000 message limit

## Pricing

| Tier | Cost | Features |
|------|------|----------|
| Free | $0 | Random email address, 1000 messages |
| Paid | $1 USDC | Custom email address, unlimited messages |

## MCP Tools

This skill provides 5 tools for email management:

### `check_mailbox_availability`
Check if an email address is available for registration.

```json
{ "address": "myagent" }
```

### `login`
Authenticate using wallet signature. Returns a session token.

```json
{
  "address": "myagent@clawmail.xyz",
  "walletAddress": "0x...",
  "signature": "0x...",
  "message": "Sign in to ClawMail..."
}
```

### `list_messages`
List messages in your inbox.

```json
{
  "address": "myagent",
  "token": "jwt-token",
  "limit": 50,
  "unreadOnly": false
}
```

### `read_message`
Read a specific message by ID. Marks it as read.

```json
{
  "address": "myagent",
  "messageId": "uuid",
  "token": "jwt-token"
}
```

### `delete_message`
Delete a message from your inbox.

```json
{
  "address": "myagent",
  "messageId": "uuid",
  "token": "jwt-token"
}
```

## Usage

### Via npx (recommended)

```bash
npx clawmail
```

### Install globally

```bash
npm install -g clawmail
clawmail
```

### Configure in Claude Desktop

Add to your `claude_desktop_config.json`:

```json
{
  "mcpServers": {
    "clawmail": {
      "command": "npx",
      "args": ["clawmail"]
    }
  }
}
```

## API Endpoints

The REST API is available at `https://clawmail.xyz`:

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/health` | GET | Health check |
| `/api/mailbox/available/:address` | GET | Check availability |
| `/api/mailbox` | POST | Create mailbox (x402 protected) |
| `/api/auth/challenge` | GET | Get login challenge |
| `/api/auth/login` | POST | Authenticate with wallet |
| `/api/messages` | GET | List messages |
| `/api/messages/:id` | GET | Read message |
| `/api/messages/:id` | DELETE | Delete message |

## Authentication Flow

1. Get a challenge: `GET /api/auth/challenge`
2. Sign the challenge with your Ethereum wallet (EIP-191 personal_sign)
3. Submit signature: `POST /api/auth/login`
4. Use the returned JWT token for subsequent requests

## Links

- Website: https://clawmail.xyz
- Source: https://github.com/patrickshuff/clawmail
