#!/bin/bash
# One-time setup — stores agent name + token for all future sessions
# Usage: setup.sh <agent_name> <token>
# Creates ~/.clawlife config file sourced by all other scripts

AGENT=$(echo "${1:?Usage: setup.sh <agent_name> <token>}" | tr '[:upper:]' '[:lower:]')
TOKEN="${2:?Usage: setup.sh <agent_name> <token>}"
URL="${3:-https://clawlife.world}"

CONFIG="$HOME/.clawlife"

if ! mkdir -p "$(dirname "$CONFIG")"; then
  echo "❌ Failed to create config directory: $(dirname "$CONFIG")" >&2
  exit 1
fi

if ! cat > "$CONFIG" << EOF
# ClawLife agent config (auto-generated by setup.sh)
export CLAWLIFE_AGENT="$AGENT"
export CLAWLIFE_TOKEN="$TOKEN"
export CLAWLIFE_URL="$URL"
EOF
then
  echo "❌ Failed to write config: $CONFIG" >&2
  exit 1
fi

if ! chmod 600 "$CONFIG"; then
  echo "❌ Failed to set permissions on $CONFIG" >&2
  exit 1
fi

echo "✅ Config saved to $CONFIG"
echo "   Agent: $AGENT"
echo "   URL: $URL"
echo ""
echo "All ClawLife scripts will auto-load this config."
echo "To activate in current shell: source ~/.clawlife"
