# K-Trendz Lightstick Trading Skill

Trade K-pop artist lightstick tokens on the K-Trendz bonding curve market.

## Overview

K-Trendz Lightsticks are digital fan tokens tied to K-pop artists. Unlike arbitrage markets, this is a **bonding curve** system where:
- **Price increases with each purchase** (√supply formula)
- **Artist popularity directly affects demand**
- **Early buyers benefit from price appreciation**

## Trading Strategy Context

This is NOT an arbitrage market. Key principles:
1. **Buy when trending** - Rising `trending_score` and recent news indicate growing demand
2. **Buy early** - Lower `total_supply` means earlier position on the curve
3. **Monitor external signals** - News headlines often precede on-platform activity
4. **Hold during growth** - Bonding curve rewards patient holders

## Available Tools

### get_token_price

Get current price and popularity signals for a token.

**Endpoint**: `POST /functions/v1/bot-get-token-price`

**Headers**:
```
x-bot-api-key: YOUR_API_KEY
Content-Type: application/json
```

**Request**:
```json
{
  "token_id": "7963681970480434413",
  // OR
  "artist_name": "RIIZE"
}
```

**Response**:
```json
{
  "success": true,
  "data": {
    "token_id": "7963681970480434413",
    "artist_name": "RIIZE",
    "current_price_usdc": 1.85,
    "buy_cost_usdc": 1.91,
    "sell_refund_usdc": 1.78,
    "price_change_24h": "+5.2",
    "total_supply": 42,
    "trending_score": 1250,
    "votes": 89,
    "follower_count": 156,
    "view_count": 2340,
    "external_signals": {
      "article_count_24h": 3,
      "headlines": [
        {"title": "RIIZE announces world tour dates", "url": "..."},
        {"title": "New single breaks records", "url": "..."}
      ],
      "has_recent_news": true
    },
    "trading_context": {
      "contract_address": "0xfe7791e3078FD183FD1c08dE2F1e4ab732024489",
      "fee_structure": {
        "buy_fee_percent": 3,
        "sell_fee_percent": 2
      }
    }
  }
}
```

**Decision Factors**:
| Field | Meaning | Buy Signal |
|-------|---------|------------|
| `trending_score` | On-platform engagement | Rising = bullish |
| `price_change_24h` | Recent momentum | Positive = trend continuation |
| `total_supply` | Holders count | Low = early opportunity |
| `external_signals.article_count_24h` | News volume | High = increased attention |
| `external_signals.has_recent_news` | Recent coverage | true = potential catalyst |

---

### buy_fanz_token

Purchase 1 lightstick token.

**Endpoint**: `POST /functions/v1/bot-buy-token`

**Headers**:
```
x-bot-api-key: YOUR_API_KEY
Content-Type: application/json
```

**Request**:
```json
{
  "token_id": "7963681970480434413",
  "max_slippage_percent": 5
}
```

**Response**:
```json
{
  "success": true,
  "data": {
    "transaction_id": "abc123",
    "tx_hash": "0x...",
    "token_id": "7963681970480434413",
    "artist_name": "RIIZE",
    "amount": 1,
    "total_cost_usdc": 1.91,
    "remaining_daily_limit": 98.09
  }
}
```

**Constraints**:
- Maximum 1 token per transaction (bonding curve protection)
- $100/day limit per agent
- Same-block trades blocked (MEV protection)

---

### sell_fanz_token

Sell 1 lightstick token.

**Endpoint**: `POST /functions/v1/bot-sell-token`

**Headers**:
```
x-bot-api-key: YOUR_API_KEY
Content-Type: application/json
```

**Request**:
```json
{
  "token_id": "7963681970480434413",
  "min_slippage_percent": 5
}
```

**Response**:
```json
{
  "success": true,
  "data": {
    "transaction_id": "def456",
    "tx_hash": "0x...",
    "token_id": "7963681970480434413",
    "artist_name": "RIIZE",
    "amount": 1,
    "net_refund_usdc": 1.78,
    "fee_usdc": 0.04
  }
}
```

---

## Available Tokens

| Artist | Token ID |
|--------|----------|
| K-Trendz Supporters | 12666454296509763493 |
| RIIZE | 7963681970480434413 |
| IVE | 4607865675402095874 |
| Cortis | 13766662462343366758 |
| BTS | 9138265216282739420 |
| All Day Project | 18115915419890895215 |

---

## Fee Structure

| Action | Fee | Distribution |
|--------|-----|--------------|
| Buy | 3% | 2% Artist Fund, 1% Platform |
| Sell | 2% | Platform |

**Round-trip cost**: 5%

---

## Example Trading Logic

```python
# Pseudocode for news-driven trading

def should_buy(token_data):
    signals = token_data['external_signals']
    
    # Strong buy: Recent news + rising trend
    if signals['has_recent_news'] and signals['article_count_24h'] >= 2:
        if token_data['price_change_24h'] and float(token_data['price_change_24h']) > 0:
            return True
    
    # Moderate buy: High trending score, low supply
    if token_data['trending_score'] > 1000 and token_data['total_supply'] < 50:
        return True
    
    return False

def should_sell(token_data, purchase_price):
    current_price = token_data['current_price_usdc']
    
    # Take profit at 10%+
    if current_price > purchase_price * 1.10:
        return True
    
    # Cut loss if no news and price dropping
    signals = token_data['external_signals']
    if not signals['has_recent_news']:
        if token_data['price_change_24h'] and float(token_data['price_change_24h']) < -5:
            return True
    
    return False
```

---

## Rate Limits

- **Daily Volume**: $100 USD per agent
- **Transaction Frequency**: Max 100 trades/day per agent
- **Circuit Breaker**: Trading pauses if price moves >20% in 10 blocks

---

## Base URL

```
https://jguylowswwgjvotdcsfj.supabase.co/functions/v1/
```

---

## Authentication

Include your API key in the `x-bot-api-key` header for all requests.

Contact K-Trendz team for API key provisioning.
