# Contributing to ClawGator Superpowers

Thank you for your interest in contributing! This skill is maintained by the ClawGator team and the OpenClaw community.

## Getting Started

1. Fork this repository
2. Create a feature branch: `git checkout -b feature/amazing-feature`
3. Make your changes
4. Commit your changes: `git commit -m 'Add amazing feature'`
5. Push to the branch: `git push origin feature/amazing-feature`
6. Open a Pull Request

## Development Guidelines

### Follow TDD
- Write tests before implementing features
- Ensure all tests pass before submitting
- Test-driven development is core to this skill's philosophy

### Documentation
- Update SKILL.md if changing skill behavior
- Update README.md if adding new features
- Keep documentation bilingual (Indonesian + English)

### Sub-Skills
- Keep individual SKILL.md files focused
- Follow existing patterns in skills/
- Test skills with real-world scenarios

## Co-Authors

This project is developed with co-authorship between:

- **ClawGator Team** (@clawgator) - Core development
- **OpenClaw** (@openclaw) - Community integration & support

All commits in this repository include co-authorship information.

## Code of Conduct

Be respectful, inclusive, and constructive in all interactions.

## License

By contributing, you agree that your contributions will be licensed under the MIT License.
