# バリュエーション算出ガイド

## 類似会社比較法 (Comps) — 計算手順

### 1. EBITDA の算出

```
EBITDA = 営業利益 + 減価償却費
```

減価償却費が不明の場合:
- P/L の販管費内訳に記載がないか確認
- なければ `[不明]` とし、営業利益のみで代替

### 2. 純有利子負債の算出

```
純有利子負債 = (短期借入金 + 長期借入金 + 役員借入金) - 現預金
```

- マイナスの場合 = ネットキャッシュ（好材料）
- 役員借入金は**必ず**有利子負債に含める

### 3. 類似企業の選定基準

以下の優先順位で類似企業を選ぶ:
1. 同一業種 (JPX 業種分類)
2. 売上規模が近い (0.5x 〜 2x)
3. 利益率が近い
4. 日本の上場企業を優先

### 4. 推定時価総額の計算

```
PER ベース:
  推定時価総額 = 当期純利益 × 中央値PER

EV/EBITDA ベース:
  EV = EBITDA × 中央値EV/EBITDA
  推定時価総額 = EV - 純有利子負債
```

### 5. ディスカウント適用

#### 非流動性ディスカウント (非上場企業)

| 条件 | ディスカウント率 |
|---|---|
| 業績安定・大手取引先あり | 20% |
| 一般的な中小企業 | 25% |
| オーナー依存・業績不安定 | 30% |

#### AI調整ディスカウント

| 項目 | ディスカウント |
|---|---|
| 役員借入金あり | -5% |
| 過剰役員報酬 (売上10%超) | -5% |
| 不透明資産 (仮払金・貸付金等) | -10% |
| 簿外債務の疑い | -10% |

**上限: 合計30%** (非流動性ディスカウントとは別枠)

### 6. 想定買収価格

```
想定買収価格 = (PERベース + EBITDAベース) ÷ 2 × (1 - 非流動性ディスカウント) × (1 - AI調整ディスカウント)
```

## 業種別の参考倍率 (デフォルト値)

あくまで直近のデータがない場合のフォールバック。必ず `[デフォルト値]` を明記すること。

| 業種 | PER (中央値) | EV/EBITDA (中央値) |
|---|---|---|
| 製造業 | 12-15x | 6-8x |
| IT・ソフトウェア | 20-30x | 12-18x |
| 小売業 | 10-15x | 5-8x |
| 建設業 | 8-12x | 4-6x |
| サービス業 | 15-20x | 8-12x |
| 飲食業 | 15-25x | 8-12x |
| 不動産業 | 10-15x | 10-15x |
| 医療・ヘルスケア | 20-35x | 12-20x |
