# 日本語勘定科目 → 標準フィールド名マッピング

PDF から抽出したテキストの勘定科目を構造化する際のリファレンス。

## 貸借対照表 (B/S)

| 日本語表記 (バリエーション) | フィールド名 | 区分 |
|---|---|---|
| 現金及び預金 / 現預金 / 現金・預金 | `cash_and_deposits` | 流動資産 |
| 売掛金 / 受取手形及び売掛金 / 営業未収金 | `accounts_receivable` | 流動資産 |
| 棚卸資産 / 商品 / 商品及び製品 / 仕掛品 | `inventory` | 流動資産 |
| 流動資産合計 / 流動資産計 | `total_current_assets` | 小計 |
| 固定資産合計 / 固定資産計 | `fixed_assets` | 小計 |
| 資産合計 / 資産の部合計 / 総資産 | `total_assets` | 合計 |
| 買掛金 / 支払手形及び買掛金 | `accounts_payable` | 流動負債 |
| 短期借入金 / 1年内返済予定の長期借入金 | `short_term_debt` | 流動負債 |
| 役員借入金 | `officer_loans` | 固定負債 |
| 流動負債合計 / 流動負債計 | `total_current_liabilities` | 小計 |
| 長期借入金 | `long_term_debt` | 固定負債 |
| 負債合計 / 負債の部合計 | `total_liabilities` | 合計 |
| 資本金 | `capital_stock` | 純資産 |
| 利益剰余金 / 繰越利益剰余金 | `retained_earnings` | 純資産 |
| 純資産合計 / 純資産の部合計 / 株主資本合計 | `total_net_assets` | 合計 |

## 損益計算書 (P/L)

| 日本語表記 (バリエーション) | フィールド名 | 区分 |
|---|---|---|
| 売上高 / 営業収益 / 売上収入 | `revenue` | 収益 |
| 売上原価 / 営業原価 | `cost_of_sales` | 費用 |
| 売上総利益 / 営業総利益 | `gross_profit` | 利益 |
| 販売費及び一般管理費 / 販管費 | `sga_expenses` | 費用 |
| 役員報酬 / 取締役報酬 | `officer_compensation` | 販管費内訳 |
| 営業利益 / 営業損失 | `operating_income` | 利益 |
| 営業外収益 | `non_operating_income` | 収益 |
| 営業外費用 | `non_operating_expenses` | 費用 |
| 経常利益 / 経常損失 | `ordinary_income` | 利益 |
| 当期純利益 / 当期純損失 | `net_income` | 最終 |
| 減価償却費 | `depreciation` | 販管費内訳 |

## 単位変換

| PDF表記 | 変換 |
|---|---|
| (単位：千円) | × 1,000 |
| (単位：百万円) | × 1,000,000 |
| (単位：円) | そのまま |
| △ or ▲ or ( ) | マイナス値 |

## 注意事項

- 「その他」に含まれる項目は無視してよい
- 「関係会社」「関連当事者」は別途リスク分析で言及する
- 金額が「-」「―」の場合は 0
- 前期比較がある場合は**当期**の数字を使う
