# CLAW Betting AI - Strategy Guide

Website: https://clawde.xyz

## Overview

This guide covers the betting strategies available in CLAW Betting AI and when to use each one.

## Strategy Comparison

| Strategy | Target | Win Rate | Progression | Risk |
|----------|--------|----------|-------------|------|
| Conservative | 1.5-2x | 50-65% | Flat | Low |
| Balanced | 2-5x | 25-45% | Mild (1.3x) | Medium |
| Aggressive | 5-20x | 5-15% | Fibonacci | High |

## Conservative Strategy

### When to Use
- You have a small bankroll
- You want long session times
- You're risk-averse
- You're learning the system

### Configuration
```json
{
  "strategy": "conservative",
  "baseBetPercent": 0.5,
  "maxBetPercent": 2,
  "targetMultiplier": { "min": 1.5, "max": 2.0 }
}
```

### Expected Results
- Session duration: 100+ bets
- Expected variance: Low
- Profit potential: Slow, steady

### Example Session
```
Bankroll: $100
Bet 1: $0.50 at 1.75x → Win (+$0.37)
Bet 2: $0.50 at 1.75x → Win (+$0.37)
Bet 3: $0.50 at 1.75x → Lose (-$0.50)
...
After 50 bets: $103.50 (+3.5%)
```

## Balanced Strategy

### When to Use
- Standard sessions
- Moderate risk tolerance
- Good bankroll (50+ bets worth)
- General purpose betting

### Configuration
```json
{
  "strategy": "balanced",
  "baseBetPercent": 1,
  "maxBetPercent": 4,
  "progression": "mild",
  "progressionMultiplier": 1.3,
  "targetMultiplier": { "min": 2.0, "max": 5.0 }
}
```

### Progression Example
```
Loss 1: $1.00 (base)
Loss 2: $1.30 (1.3x)
Loss 3: $1.69 (1.3x)
Loss 4: $2.20 (1.3x)
Win → Reset to $1.00
```

### Expected Results
- Session duration: 30-80 bets
- Expected variance: Medium
- Profit potential: Moderate gains possible

## Aggressive Strategy

### When to Use
- Large bankroll
- High risk tolerance
- Recovery situations
- Short sessions

### Configuration
```json
{
  "strategy": "aggressive",
  "baseBetPercent": 2,
  "maxBetPercent": 8,
  "progression": "fibonacci",
  "targetMultiplier": { "min": 5.0, "max": 20.0 }
}
```

### Fibonacci Progression
```
Sequence: 1, 1, 2, 3, 5, 8, 13, 21...

Loss 1: $2.00 (1x base)
Loss 2: $2.00 (1x base)
Loss 3: $4.00 (2x base)
Loss 4: $6.00 (3x base)
Loss 5: $10.00 (5x base)
Win → Move back 2 positions
```

### Expected Results
- Session duration: 10-30 bets
- Expected variance: High
- Profit potential: Large swings both ways

## Mathematical Basis

### Kelly Criterion

The optimal bet size according to Kelly:

```
f* = (bp - q) / b

where:
  f* = optimal fraction of bankroll
  b = odds (multiplier - 1)
  p = probability of winning
  q = probability of losing (1 - p)
```

**Example for 2x target:**
- b = 1 (2x - 1)
- p = 0.45 (estimated)
- q = 0.55

```
f* = (1 × 0.45 - 0.55) / 1 = -0.10
```

Negative Kelly suggests the bet has negative expected value. This is why we use fractional Kelly (bet less than optimal).

### Expected Value

For crash games:
```
EV = (WinRate × Payout) - (1 - WinRate)

At 2x target with 45% win rate:
EV = (0.45 × 1.0) - (0.55) = -0.10 or -10%
```

The house edge means long-term expected value is negative. Strategy focuses on:
1. Managing variance
2. Maximizing entertainment value
3. Hitting take-profit before expected losses accumulate

## Risk Management

### Stop-Loss Rules

| Situation | Action |
|-----------|--------|
| -20% of bankroll | End session |
| 5 consecutive losses | 5-minute break |
| 8 consecutive losses | End session |
| Tilt detected | Reset to base bet |

### Take-Profit Rules

| Situation | Action |
|-----------|--------|
| +30% of bankroll | Consider stopping |
| +50% of bankroll | Lock 50% of profits |
| +100% of bankroll | Strongly consider stopping |

### Tilt Prevention

Signs of tilt:
- Increasing bets after losses beyond progression
- Chasing losses with higher targets
- Ignoring cooldown recommendations
- Betting faster than normal

When tilt is detected:
1. System resets to base bet
2. Warning is issued
3. If ignored, session may be ended

## Choosing Your Strategy

### Decision Tree

```
Is your bankroll < 50× base bet?
  → Use Conservative

Are you recovering from losses?
  → Use Aggressive (with caution)

Is this a casual session?
  → Use Balanced

Are you risk-averse?
  → Use Conservative

Do you have high risk tolerance?
  → Use Aggressive

Default → Use Balanced
```

## Custom Strategies

You can create custom strategies in your config:

```json
{
  "strategies": {
    "custom": {
      "targetMultiplier": { "min": 3.0, "max": 3.5 },
      "baseBetPercent": 1.5,
      "maxBetPercent": 6,
      "progression": "mild",
      "progressionMultiplier": 1.5,
      "expectedWinRate": 0.28
    }
  }
}
```

Then use:
```python
get_recommendation(..., strategy="custom")
```

## Disclaimer

All strategies carry risk. Past performance doesn't guarantee future results. Gamble responsibly.

---

Website: https://clawde.xyz
