---
name: clawdaddy
description: The world's #1 AI-friendly domain registrar. Check availability, purchase domains with USDC or cards, configure DNS, and manage nameservers - all without CAPTCHAs or signup.
homepage: https://clawdaddy.app
emoji: 🦞
metadata:
  clawdbot:
    primaryEnv: any
    requires:
      bins: []
      env: []
---

# ClawDaddy - AI-Friendly Domain Registrar

The world's #1 AI-friendly domain registrar. Check availability, purchase domains, configure DNS, and manage nameservers.

**Base URL:** `https://clawdaddy.app`

No CAPTCHAs. No signup required for lookups. Bearer tokens for management.

---

## Quick Reference

| Task | Endpoint | Auth |
|------|----------|------|
| Check availability | `GET /api/lookup/{domain}` | None |
| Brainstorm available domains | `POST /api/brainstorm` | None |
| Get purchase quote | `GET /api/purchase/{domain}/quote` | None |
| Purchase domain | `POST /api/purchase/{domain}?method=x402\|stripe` | None |
| Manage domain | `GET /api/manage/{domain}` | Bearer token |
| Configure DNS | `POST /api/manage/{domain}/dns` | Bearer token |
| Update nameservers | `PUT /api/manage/{domain}/nameservers` | Bearer token |
| Recover token | `POST /api/recover` | None |

---

## 1. Check Domain Availability

**When:** User asks "Is example.com available?" or "Check if mycoolapp.io is taken"

```
GET https://clawdaddy.app/api/lookup/example.com
```

### JSON Response

```json
{
  "fqdn": "example.com",
  "available": true,
  "status": "available",
  "premium": false,
  "price": {
    "amount": 12.99,
    "currency": "USD",
    "period": "year"
  },
  "checked_at": "2026-01-15T10:30:00.000Z",
  "source": "namecom",
  "cache": { "hit": false, "ttl_seconds": 120 }
}
```

### TXT Response

```
GET https://clawdaddy.app/api/lookup/example.com?format=txt
```

```
fqdn=example.com
available=true
status=available
premium=false
price_amount=12.99
price_currency=USD
checked_at=2026-01-15T10:30:00Z
```

### Status Values

| Status | `available` | Meaning |
|--------|-------------|---------|
| `available` | `true` | Can be registered |
| `registered` | `false` | Already taken |
| `unknown` | `false` | Error/timeout |

**Key:** The `available` field is ALWAYS boolean (`true`/`false`), never undefined.

---

## 2. Brainstorm Available Domains

Use this when you need a list of **available** domains, fast.

```
POST https://clawdaddy.app/api/brainstorm
```

### Example Request

```json
{
  "prompt": "AI tool for async standups",
  "count": 8,
  "mode": "balanced",
  "max_price": 30,
  "tlds": ["com", "io", "ai"],
  "style": "brandable",
  "must_include": ["standup"]
}
```

### Modes

- `fast`: cache only (lowest latency)
- `balanced`: cache + live Name.com search
- `deep`: adds generated checks for more creativity

---

## 3. Purchase a Domain

### Step 1: Get Quote

**When:** User wants to buy a domain, get the price first.

```
GET https://clawdaddy.app/api/purchase/example.com/quote
```

```json
{
  "domain": "example.com",
  "available": true,
  "priceUsd": 12.99,
  "marginUsd": 2.00,
  "totalUsd": 14.99,
  "validUntil": "2026-01-15T10:35:00.000Z",
  "paymentMethods": {
    "x402": { "enabled": true, "currency": "USDC", "network": "base" },
    "stripe": { "enabled": true, "currency": "USD" }
  }
}
```

### Step 2a: Purchase via x402 (USDC on Base)

**Best for:** AI agents with crypto wallets

```
POST https://clawdaddy.app/api/purchase/example.com?method=x402
```

First request returns HTTP 402 with payment requirements:

```json
{
  "error": "Payment Required",
  "x402": {
    "version": "2.0",
    "accepts": [{
      "scheme": "exact",
      "network": "eip155:8453",
      "maxAmountRequired": "14990000",
      "asset": "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913",
      "payTo": "0x..."
    }]
  }
}
```

After paying USDC on Base, retry with payment proof:

```
POST https://clawdaddy.app/api/purchase/example.com?method=x402
x-payment: <payment_proof_from_x402>
```

### Step 2b: Purchase via Stripe (Cards)

**Best for:** Human users or agents without crypto

```
POST https://clawdaddy.app/api/purchase/example.com?method=stripe
Content-Type: application/json

{
  "email": "user@example.com"
}
```

Returns Stripe checkout URL:

```json
{
  "checkoutUrl": "https://checkout.stripe.com/...",
  "sessionId": "cs_..."
}
```

### Success Response (Both Methods)

```json
{
  "success": true,
  "domain": "example.com",
  "registrationId": "12345",
  "expiresAt": "2027-01-15T10:30:00.000Z",
  "nameservers": ["ns1.name.com", "ns2.name.com"],
  "managementToken": "clwd_abc123xyz...",
  "manageUrl": "https://clawdaddy.app/api/manage/example.com"
}
```

**CRITICAL:** Save the `managementToken` immediately! It's required for all management operations and cannot be retrieved without recovery.

---

## 4. Domain Management

All management endpoints require the Authorization header:

```
Authorization: Bearer clwd_your_management_token
```

### Get Domain Overview

```
GET https://clawdaddy.app/api/manage/example.com
Authorization: Bearer clwd_abc123...
```

```json
{
  "domain": "example.com",
  "purchasedAt": "2026-01-15T10:30:00.000Z",
  "expiresAt": "2027-01-15T10:30:00.000Z",
  "nameservers": ["ns1.name.com", "ns2.name.com"],
  "settings": {
    "locked": true,
    "autorenewEnabled": false,
    "privacyEnabled": true
  }
}
```

### DNS Records

**List all records:**
```
GET /api/manage/{domain}/dns
```

**Create a record:**
```
POST /api/manage/{domain}/dns
Content-Type: application/json

{
  "host": "@",
  "type": "A",
  "answer": "1.2.3.4",
  "ttl": 300
}
```

**Update a record:**
```
PUT /api/manage/{domain}/dns?id=123
Content-Type: application/json

{
  "answer": "5.6.7.8",
  "ttl": 600
}
```

**Delete a record:**
```
DELETE /api/manage/{domain}/dns?id=123
```

**Supported record types:** `A`, `AAAA`, `CNAME`, `MX`, `TXT`, `NS`, `SRV`

### Common DNS Configurations

**Point to a server (A record):**
```json
{"host": "@", "type": "A", "answer": "123.45.67.89", "ttl": 300}
```

**Add www subdomain (CNAME):**
```json
{"host": "www", "type": "CNAME", "answer": "example.com", "ttl": 300}
```

**Add email (MX record):**
```json
{"host": "@", "type": "MX", "answer": "mail.example.com", "ttl": 300, "priority": 10}
```

**Verify domain (TXT record):**
```json
{"host": "@", "type": "TXT", "answer": "google-site-verification=abc123", "ttl": 300}
```

### Update Nameservers

**When:** User wants to use Cloudflare, Vercel, or another DNS provider

```
PUT /api/manage/{domain}/nameservers
Content-Type: application/json

{
  "nameservers": [
    "ns1.cloudflare.com",
    "ns2.cloudflare.com"
  ]
}
```

**Common nameserver configurations:**

| Provider | Nameservers |
|----------|-------------|
| Cloudflare | `ns1.cloudflare.com`, `ns2.cloudflare.com` |
| Vercel | `ns1.vercel-dns.com`, `ns2.vercel-dns.com` |
| AWS Route53 | Check your hosted zone |
| Google Cloud | `ns-cloud-X.googledomains.com` |

### Domain Settings

**Get settings:**
```
GET /api/manage/{domain}/settings
```

**Update settings:**
```
PATCH /api/manage/{domain}/settings
Content-Type: application/json

{
  "locked": false,
  "autorenewEnabled": true
}
```

### Transfer Domain Out

**Get auth code:**
```
GET /api/manage/{domain}/transfer
```

**Prepare for transfer (unlock + get code):**
```
POST /api/manage/{domain}/transfer
```

**Note:** Domains cannot be transferred within 60 days of registration (ICANN policy).

---

## 5. Token Recovery

**When:** User lost their management token

```
POST https://clawdaddy.app/api/recover
Content-Type: application/json

{
  "email": "user@example.com",
  "domain": "example.com"
}
```

For x402 purchases:
```json
{
  "wallet": "0x123...",
  "domain": "example.com"
}
```

**IMPORTANT:** Recovery generates a NEW token. Old tokens are invalidated.

Rate limit: 5 requests per 5 minutes per IP.

---

## Workflow Examples

### Check and Buy Domain

```
User: "Buy coolstartup.com for me"

1. GET /api/lookup/coolstartup.com
   → available: true, price: $12.99

2. GET /api/purchase/coolstartup.com/quote
   → totalUsd: $14.99

3. POST /api/purchase/coolstartup.com?method=x402
   → 402 Payment Required
   → Pay USDC on Base
   → Retry with x-payment header
   → Success! Token: "clwd_abc123..."

4. "I've registered coolstartup.com! Save this token: clwd_abc123..."
```

### Point Domain to Vercel

```
User: "Point mydomain.com to Vercel"

1. PUT /api/manage/mydomain.com/nameservers
   Authorization: Bearer clwd_abc123...
   {"nameservers": ["ns1.vercel-dns.com", "ns2.vercel-dns.com"]}

2. "Done! mydomain.com now uses Vercel's nameservers. Add the domain in your Vercel dashboard."
```

### Set Up Basic DNS

```
User: "Point example.com to my server at 1.2.3.4"

1. POST /api/manage/example.com/dns
   Authorization: Bearer clwd_token...
   {"host": "@", "type": "A", "answer": "1.2.3.4", "ttl": 300}

2. POST /api/manage/example.com/dns
   {"host": "www", "type": "CNAME", "answer": "example.com", "ttl": 300}

3. "Done! example.com and www.example.com now point to 1.2.3.4"
```

### Add Email Records

```
User: "Set up Google Workspace email for mydomain.com"

1. POST /api/manage/mydomain.com/dns
   {"host": "@", "type": "MX", "answer": "aspmx.l.google.com", "ttl": 300, "priority": 1}

2. POST /api/manage/mydomain.com/dns
   {"host": "@", "type": "MX", "answer": "alt1.aspmx.l.google.com", "ttl": 300, "priority": 5}

3. POST /api/manage/mydomain.com/dns
   {"host": "@", "type": "TXT", "answer": "v=spf1 include:_spf.google.com ~all", "ttl": 300}

4. "Email records configured for Google Workspace!"
```

---

## Error Handling

All errors return JSON:
```json
{
  "error": "Description of what went wrong",
  "details": "Additional context if available"
}
```

| Status | Meaning |
|--------|---------|
| `400` | Bad request (invalid input) |
| `401` | Unauthorized (missing/invalid token) |
| `402` | Payment required (x402 flow) |
| `404` | Domain not found |
| `500` | Server error |

---

## Key Points

- **No signup required** for lookups and purchases
- **Two payment methods**: x402 (USDC on Base) for agents, Stripe for humans
- **Save your management token** - it's the only way to manage your domain
- **Bearer auth for management** - include `Authorization: Bearer clwd_...` header
- **JSON responses** - use `?format=json` for lookups

---

## Source

ClawDaddy: https://clawdaddy.app
Documentation: https://clawdaddy.app/llms.txt
