# Sport-Specific Workout Library

## Swimming

### Workout Types

| Session Type      | Structure                          | Zone | When to Use              |
| ----------------- | ---------------------------------- | ---- | ------------------------ |
| Technique         | 6-8 x 50m drill/swim, 15s rest     | 1-2  | Every session warm-up    |
| Aerobic Endurance | 3-5 x 400m @ CSS+10s, 20s rest     | 2    | Base phase, 1-2x/week    |
| Threshold         | 8-12 x 100m @ CSS, 10-15s rest     | 4    | Build phase, 1x/week     |
| VO2max            | 6-8 x 100m @ CSS-5s, 20-30s rest   | 5    | Peak phase, 1x/week      |
| Race-Specific     | 1-2 x race distance @ goal pace    | 3-4  | Every 2-3 weeks in build |
| Open Water        | Continuous swim, sighting practice | 2-3  | Monthly if racing OW     |

### Sample Sessions (2500m total)

**Aerobic Endurance:**

```
Warm-up: 300m easy, 4x50m drill (catch-up, fingertip drag)
Main: 5 x 400m @ CSS+8sec/100m, 20s rest
Cool-down: 200m easy pull
```

**Threshold Development:**

```
Warm-up: 400m easy, 4x50m build
Pre-main: 4 x 100m descend 1-4
Main: 3 x (4 x 100m @ CSS, 10s rest), 60s between sets
Cool-down: 200m easy
```

**VO2max (advanced):**

```
Warm-up: 300m, 6x50m drill/swim
Main: 8 x 100m @ CSS-5sec, 30s rest
       4 x 50m FAST, 30s rest
Cool-down: 300m easy
```

### Common Limiters & Solutions

| Limiter            | Indicators                       | Prescription                         |
| ------------------ | -------------------------------- | ------------------------------------ |
| Technique          | High stroke count, early fatigue | 30% of swim volume as drills         |
| Aerobic base       | Can't sustain pace beyond 400m   | More Zone 2 continuous swimming      |
| Threshold          | Pace drops sharply in sets       | More CSS-pace work with short rest   |
| Open water anxiety | Pool-only history                | Monthly OW sessions, sighting drills |

---

## Cycling

### Workout Types

| Session Type | Structure                                    | Zone/Power   | When to Use                    |
| ------------ | -------------------------------------------- | ------------ | ------------------------------ |
| Endurance    | 2-5hr steady                                 | 56-75% FTP   | Weekly, base phase emphasis    |
| Tempo        | 2-3 x 20min continuous                       | 76-90% FTP   | Base/build, muscular endurance |
| Sweet Spot   | 2-3 x 20-30min                               | 88-93% FTP   | Build phase, 1-2x/week         |
| Threshold    | 3-4 x 10-12min, 5min rest                    | 95-105% FTP  | Build/peak, 1x/week            |
| VO2max       | 5-6 x 4-5min, 4min rest                      | 106-120% FTP | Peak phase, 1x/week            |
| Over-Unders  | 3 x (8min: 2min @95%, 1min @105%), 5min rest | 4-5a         | Threshold extension            |
| Hill Repeats | 4-6 x 5-8min climb, descent recovery         | 100-110% FTP | Climbing races                 |

### Sample Sessions

**Sweet Spot (Build Phase Staple):**

```
Warm-up: 20min Zone 2, include 2x1min high-cadence
Main: 3 x 25min @ 88-92% FTP, 5min easy between
Cool-down: 15min Zone 1
Total: 2hr, ~80 TSS
```

**VO2max Development:**

```
Warm-up: 20min progressive to Zone 3
Main: 5 x 5min @ 110-115% FTP, 5min @ 50% FTP recovery
Cool-down: 15min easy spin
Total: 1:30, ~90 TSS
```

**Over-Under Threshold:**

```
Warm-up: 20min with 3x30s accelerations
Main: 4 x 9min [(2min @ 95% FTP, 1min @ 108% FTP) x3], 5min rest
Cool-down: 15min Zone 1
Total: 1:45, ~85 TSS
```

### Brick Workouts (Triathlon-Specific)

| Race         | Bike Portion                       | Run Portion          | Purpose                    |
| ------------ | ---------------------------------- | -------------------- | -------------------------- |
| Sprint prep  | 45min w/ 10min @ race effort       | 15min @ race pace    | Transition practice        |
| Olympic prep | 90min w/ 30min @ race effort       | 20-30min @ race pace | Pace calibration           |
| 70.3 prep    | 3hr w/ final hour @ race effort    | 30-45min easy        | Fatigue adaptation         |
| Ironman prep | 4-5hr w/ final 90min @ race effort | 45-60min easy        | Pacing, nutrition practice |

---

## Running

### Workout Types

| Session Type     | Structure               | Pace/Zone                           | When to Use               |
| ---------------- | ----------------------- | ----------------------------------- | ------------------------- |
| Recovery         | 30-45min very easy      | Zone 1, E+30s/km                    | After hard days           |
| Aerobic          | 45-75min steady         | Zone 2, E pace                      | 60-70% of run volume      |
| Long Run         | 90min-3hr               | Zone 2, start easy, finish moderate | Weekly, primary endurance |
| Tempo            | 20-40min continuous     | Zone 4, T pace                      | Build phase, 1x/week      |
| Cruise Intervals | 4-6 x 1mi, 60-90s jog   | T pace                              | Threshold development     |
| VO2max Intervals | 5-6 x 1000m, 400m jog   | I pace                              | Peak phase, 1x/week       |
| Repetitions      | 8-12 x 400m, 400m jog   | R pace                              | Speed, late build/peak    |
| Progression      | Last 25% at faster pace | E → M → T                           | Race simulation           |
| Fartlek          | Unstructured speed play | Varies                              | Mental break, adaptable   |

### Sample Sessions

**Threshold Cruise Intervals:**

```
Warm-up: 15min easy, 4x100m strides
Main: 5 x 1600m @ T pace (LTHR 100%), 90s jog recovery
Cool-down: 10min easy
Total: 75min, moderate-high stress
```

**VO2max Development:**

```
Warm-up: 15min easy, 6x100m strides
Main: 5 x 1000m @ I pace (LTHR 103-106%), 400m jog recovery
Cool-down: 15min easy
Total: 60min, high stress
```

**Marathon-Specific Long Run:**

```
Warm-up: 2km very easy
Main: 24km total
      - First 16km @ E pace (Zone 2)
      - Final 8km @ M pace (Zone 3)
Cool-down: 1km walk/easy jog
Nutrition: Practice race-day fueling every 30-45min
```

**Progression Run (Advanced):**

```
16km total:
- 0-6km: Easy (Zone 2)
- 6-10km: Steady (Zone 2-3)
- 10-14km: Tempo (Zone 4)
- 14-16km: Threshold (Zone 5a)
Great for teaching pace discipline and finishing strong
```

### Long Run Targets by Event

| Event         | Peak Long Run    | Frequency       | Notes                            |
| ------------- | ---------------- | --------------- | -------------------------------- |
| 5K            | 10-12km          | Weekly          | Some quality in long runs OK     |
| 10K           | 14-16km          | Weekly          | Include some tempo               |
| Half Marathon | 18-22km          | Weekly          | 1-2 runs at goal pace            |
| Marathon      | 32-35km          | Every 2-3 weeks | Don't exceed 3.5hr               |
| Ultra (50K)   | 35-45km or 4-5hr | Every 2-3 weeks | Time-based, practice nutrition   |
| Ultra (100K+) | 50-60km or 5-6hr | Monthly         | Back-to-back long runs work well |

---

## Strength Training

Strength work is essential for injury prevention, power development, and late-race durability. Include 1-2 sessions per week.

### Workout Types

| Session Type | Structure                          | When to Use            |
| ------------ | ---------------------------------- | ---------------------- |
| Foundation   | 2-3 sets x 12-15 reps, bodyweight  | Base phase, beginners  |
| Strength     | 3-4 sets x 6-8 reps, moderate load | Build phase, 1-2x/week |
| Power        | 3-4 sets x 4-6 reps, explosive     | Peak phase, 1x/week    |
| Maintenance  | 2 sets x 8-10 reps, light          | Race week, taper       |

### Core Exercises (Every Session)

```
Plank: 3 x 45-60s
Side plank: 2 x 30s each side
Dead bug: 2 x 12 each side
Bird dog: 2 x 10 each side
```

### Triathlete-Specific Exercises

| Focus        | Exercises                                    | Why                               |
| ------------ | -------------------------------------------- | --------------------------------- |
| Swim power   | Lat pulldown, pull-ups, band pull-aparts     | Catch strength, stroke power      |
| Bike power   | Squats, leg press, step-ups, single-leg work | Pedaling force, hill climbing     |
| Run strength | Lunges, Romanian deadlifts, calf raises      | Push-off power, injury prevention |
| Stability    | Single-leg squats, BOSU work, hip circles    | Balance, proprioception           |

### Sample Session (45min)

```
Warm-up: 5min light cardio, dynamic stretches
Circuit 1 (3 rounds):
  - Goblet squats x 10
  - Push-ups x 12
  - Single-leg Romanian deadlift x 8 each
Circuit 2 (3 rounds):
  - Lat pulldown x 10
  - Step-ups x 10 each leg
  - Plank x 45s
Cool-down: 5min stretching
```

### Timing Considerations

- **Before endurance**: Light activation only (bands, bodyweight)
- **After easy sessions**: Full strength OK
- **Separate from key workouts**: 6+ hours apart, or different days
- **Taper**: Reduce to maintenance (2 sets, lighter weight)

---

## Multiple Workouts Per Day (Doubles)

Doubling up sessions is common in triathlon. Guidelines:

### When to Use Doubles

| Scenario                | Example                    | Notes                        |
| ----------------------- | -------------------------- | ---------------------------- |
| Brick workouts          | Bike → Run                 | Race simulation, transition  |
| Time-efficient training | AM swim + PM run           | Separate by 6+ hours ideally |
| High-volume phases      | Easy swim AM + bike PM     | Keep one session easy        |
| Strength + cardio       | AM strength + PM easy ride | Strength first when fresh    |

### Rules for Doubles

1. **Never two quality sessions on the same day** - One hard, one easy
2. **Separate key sessions** - 6+ hours between, or easy/hard split
3. **Fuel between sessions** - Carbs and protein within 30min of first session
4. **Sleep matters more** - Skip the double if sleep-deprived
5. **Consider weekly load** - Doubles add stress; reduce elsewhere if needed

### Sample Double Days

**Triathlon Build Phase:**

```
AM: 45min technique swim (easy)
PM: 90min bike with sweet spot intervals (quality)
```

**Weekend Long Day:**

```
AM: 3hr long ride (quality)
PM: 30min easy transition run (easy)
```

**Time-Crunched Weekday:**

```
Lunch: 30min strength (moderate)
PM: 60min easy run (easy)
```

---

## Session Intensity Distribution (Polarized Model)

For endurance events, 80% of volume should be easy (Zone 1-2), 20% hard (Zone 4+). Avoid excessive Zone 3 "gray zone" training.

| Zone         | % of Weekly Volume | Purpose                       |
| ------------ | ------------------ | ----------------------------- |
| 1-2 (Easy)   | 75-80%             | Aerobic development, recovery |
| 3 (Moderate) | 5-10%              | Race-specific only            |
| 4-5 (Hard)   | 15-20%             | Stimulus for adaptation       |
