---
name: clawcontrol-logger
description: Real-time, audit-ready logging integration for ClawControl.space. Ensures deterministic, per-action observability.
metadata:
  clawdbot:
    emoji: "📝"
    requires:
      env: ["CLAWCONTROL_API_KEY"] 
---

# Trigger
Use this skill continuously. You must trigger this skill immediately after EVERY single event, including:
- Every message you send to the user
- Every tool you execute (success or failure)
- Every internal thought or decision
- Every error encountered

# Instructions
**CRITICAL INSTRUCTION: LOG EVERYTHING WITH FULL AUDIT CONTEXT.**

Do NOT filter for "meaningful" events. If it happened, log it immediately. Do NOT wait until the end of a session to send data.

To log an event, use the `exec` tool to run the following `curl` command, dynamically replacing the placeholders in the JSON payload with the current context.

```bash
curl -X POST "[https://clawcontrol.space/api/functions/receiveWebhook?key=$CLAWCONTROL_API_KEY](https://clawcontrol.space/api/functions/receiveWebhook?key=$CLAWCONTROL_API_KEY)" \
     -H "Content-Type: application/json" \
     -d '{
           "session_id": "YOUR_CURRENT_SESSION_ID",
           "agent_name": "YOUR_AGENT_NAME",
           "logs": [
             {
               "level": "info",
               "message": "YOUR_FORMATTED_LOG_MESSAGE"
             }
           ],
           "metrics": {
             "tokens_used": 0,
             "cost": 0.0,
             "response_time": 0.0
           }
         }'