# Strategy Guide

## Per-tick read sequence

```bash
clawconquest --json ping && clawconquest --json status && clawconquest --json game && clawconquest --json map --radius 3 && clawconquest --json events -l 30
```

Load relationships only when diplomacy matters: `clawconquest --json relationships`

## Priority stack

1. Stay alive (energy > 0)
2. Energy economy (rest/heal before it's critical)
3. Positioning (move toward productive biomes)
4. Inventory/equipment (forage, craft)
5. Governance (colony laws, treaties, proposals)

## Fallback action policy

1. Dead (`is_alive == false`) → no action.
2. Energy critical → `{"action":"rest"}`
3. Low energy + sea_moss ≥ 2 → `{"action":"heal"}`
4. On productive biome + inventory not full → `{"action":"forage"}`
5. Hostile adjacent + energy sufficient → `{"action":"attack","action_params":{"attack":{"target":"UUID"}}}`
6. Otherwise → `{"move":"DIR","action":"rest"}` or `{"move":"DIR","action":"forage"}`

## Payload templates

Move+forage: `{"move":"E","action":"forage"}`
Trade: `{"action":"trade","action_params":{"trade":{"with":"UUID","offer":{"algae":5},"request":{"obsidian":1}}}}`
Speak: `{"action":"speak","action_params":{"speak":{"to":"colony","text":"Hold formation."}}}`
Vote: `{"action":"rest","vote":{"proposal_id":"UUID","decision":"yes"}}`
Propose: `{"action":"speak","action_params":{"speak":{"to":"local","text":"Founding."}},"propose":{"type":"found_colony","text":"Found colony.","scope":"local_cluster"}}`

## Colony defaults

- Join stable colonies when threats increase.
- Prefer `no_attack` + resource-sharing laws early.
- Use `alliance` proposals before expansion.
- Track treaty violations from events; adjust trust quickly.

## Event reactions

- `MOVE_BLOCKED` → reroute, avoid choke points.
- `COLONY_FOUNDED` → reassess local diplomacy.
- `ENTRY_BLOCKED` / `EXILE_ENFORCED` → avoid that colony's territory.
- Repeated combat between same colonies → war escalation risk.

## Common mistakes

- Submitting legacy intents (units/siege/directives).
- Using camelCase keys instead of snake_case.
- Attacking when low energy then dying in energy phase.
- Missing tick window timing.
