---
name: clawconnect
description: "ClawConnect - Universal account connector for AI agents. Send tweets, read/send Gmail, manage calendar, send Slack messages, and more through one API."
---

# ClawConnect

Universal account connector for AI agents. One API to access Gmail, Calendar, Twitter, Slack, and Discord.

## Setup

1. Go to https://clawconnect.dev and sign up
2. Connect your accounts (Twitter, Gmail, Calendar, Slack, Discord)
3. Get your API key from the dashboard
4. All requests require `Authorization: Bearer <API_KEY>`

Base URL: `https://clawconnect.dev`

## API Endpoints

### Connections

List connected accounts:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/connections
```

### Twitter

Get your Twitter profile:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/twitter/me
```

Get timeline:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/twitter/timeline
```

Post a tweet:
```bash
curl -X POST -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"text": "Hello from ClawConnect!"}' \
  https://clawconnect.dev/api/v1/twitter/tweet
```

### Gmail

List emails (with optional search query and max results):
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  "https://clawconnect.dev/api/v1/gmail/messages?q=is:unread&maxResults=10"
```

Get email by ID:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/gmail/messages/MESSAGE_ID
```

Send email:
```bash
curl -X POST -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"to": "recipient@example.com", "subject": "Hello", "body": "Email body here"}' \
  https://clawconnect.dev/api/v1/gmail/send
```

### Calendar

List events (with optional time range and max results):
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  "https://clawconnect.dev/api/v1/calendar/events?timeMin=2025-01-01T00:00:00Z&timeMax=2025-01-31T23:59:59Z&maxResults=20"
```

### Slack

List workspace users:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/slack/users
```

List channels:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/slack/channels
```

Get your Slack profile:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/slack/profile
```

Send a message (channel can be a channel ID or user ID):
```bash
curl -X POST -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"channel": "C01234ABCDE", "text": "Hello!"}' \
  https://clawconnect.dev/api/v1/slack/send
```

### Discord

Get your Discord profile:
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/discord/me
```

List guilds (servers):
```bash
curl -H "Authorization: Bearer $CLAWCONNECT_API_KEY" \
  https://clawconnect.dev/api/v1/discord/guilds
```

## Notes

- Confirm before sending tweets or emails.
- Use `q` parameter on Gmail to filter (same syntax as Gmail search).
- Calendar `timeMin`/`timeMax` accept ISO 8601 timestamps.
- Discord send is currently disabled (user OAuth limitation). Read-only for now.
- For Slack with multiple workspaces, pass `connection_id` to target a specific connection.
