// Core types for clawchat

export interface Identity {
  principal: string;          // stacks:<address>
  address: string;            // raw Stacks address
  publicKey: Uint8Array;      // node public key (Ed25519)
  privateKey: Uint8Array;     // node private key (Ed25519)
}

export interface Peer {
  principal: string;
  address?: string;           // last known locator (ip:port)
  alias?: string;
  lastSeen?: number;
}

export interface Message {
  id: string;
  from: string;               // principal
  /** Optional nickname of sender */
  fromNick?: string;
  to: string;                 // principal
  content: string;
  timestamp: number;
  status: 'pending' | 'sent' | 'delivered' | 'failed';
}

export interface QueuedMessage extends Message {
  retries: number;
  nextRetry?: number;
}

export interface Config {
  dataDir: string;
  listenPort?: number;
  daemon?: {
    pidFile: string;
    logFile: string;
  };
}

// Wire protocol message types
export enum MessageType {
  HELLO = 0x01,
  AUTH = 0x02,
  AUTH_OK = 0x03,
  AUTH_FAIL = 0x04,
  OPEN_STREAM = 0x10,
  CLOSE_STREAM = 0x11,
  STREAM_DATA = 0x12,
  PING = 0x20,
  PONG = 0x21,
  KNOCK = 0x30,
  ERROR = 0xff,
}

export interface NodeKeyAttestation {
  version: number;
  principal: string;
  nodePublicKey: Uint8Array;
  issuedAt: number;
  expiresAt: number;
  nonce: Uint8Array;
  domain: string;
  signature: Uint8Array;
}

// Gateway architecture types
export type { IdentityConfig, GatewayConfig, LoadedIdentity } from './types/gateway.js';
export { GatewayConfigError } from './types/gateway.js';
