#!/bin/bash
# Example: How each agent handles dinner responses

# This would be in each agent's message handling logic

# When an agent receives "I want pizza" from their human
AGENT_NAME="peter"  # Example for Peter's agent
HUMAN_RESPONSE="Pizza"
TODAY=$(date +%Y-%m-%d)

# 1. Check if there's an active dinner poll via ClawChat messages
POLL_MSG=$(clawchat --data-dir "$HOME/.clawchat-$AGENT_NAME" recv --timeout 1 --password "${AGENT_NAME}-secure-2026" | \
    jq -r '.[] | select(.content | startswith("DINNER_POLL_ACTIVE")) | .content')

if [ ! -z "$POLL_MSG" ]; then
    # Extract poll file path
    POLL_FILE=$(echo "$POLL_MSG" | cut -d: -f3)
    
    # 2. Update shared poll file
    if [ -f "$POLL_FILE" ]; then
        # Read current state
        current=$(cat "$POLL_FILE")
        
        # Update with response
        updated=$(echo "$current" | jq --arg name "$AGENT_NAME" --arg vote "$HUMAN_RESPONSE" \
            '.responses[$name] = $vote | .missing_responses = (.missing_responses - [$name])')
        
        echo "$updated" > "$POLL_FILE"
        
        # 3. Notify Cora via ClawChat
        CORA_PRINCIPAL="stacks:STBV3FG31XTNAQ2XAVRME96DHP8VR6X1XP997G35"
        clawchat --data-dir "$HOME/.clawchat-$AGENT_NAME" send "$CORA_PRINCIPAL" \
            "DINNER_VOTE:$AGENT_NAME:$HUMAN_RESPONSE" \
            --password "${AGENT_NAME}-secure-2026"
        
        echo "Dinner vote recorded and Cora notified"
    fi
else
    # No active poll found - might want to check shared directory directly
    echo "No active dinner poll found in ClawChat messages"
fi
