#!/bin/bash
# EXAMPLE: Coordinated polling system using ClawChat
#
# This example demonstrates how to coordinate multiple agents for collecting
# responses to a poll or survey. Adapt for your specific use case:
# - Team standup collection
# - Status reports
# - Voting systems
# - Any distributed data collection
#
# DO NOT use real phone numbers or personal info in examples!

SHARED_DIR="$HOME/.openclaw/workspace/shared"
TODAY=$(date +%Y-%m-%d)
POLL_FILE="$SHARED_DIR/dinner-poll-$TODAY.json"

# Create initial poll state
cat > "$POLL_FILE" << EOF
{
  "poll_time": "$(date -u +%Y-%m-%dT%H:%M:%SZ)",
  "summary_time": "$(date -u -d '+1.5 hours' +%Y-%m-%dT%H:%M:%SZ)",
  "status": "collecting",
  "responses": {},
  "missing_responses": ["Alex", "Peter", "Kathryn", "Andrew", "Matthew"]
}
EOF

# Example: Send poll via your messaging system
# Replace with your actual messaging integration
# echo "Sending poll to users..."
# your-messaging-tool send "What's your preference? Please vote!"

# Notify all agents via ClawChat about the poll
# CUSTOMIZE: Replace with your agent names
AGENTS=("agent1" "agent2" "agent3")
COORDINATOR_PRINCIPAL="stacks:YOUR_COORDINATOR_PRINCIPAL_HERE"

for agent in "${AGENTS[@]}"; do
    # Get agent's principal
    agent_principal=$(clawchat --data-dir "$HOME/.clawchat-$agent" identity show --password "${agent}-secure-2026" 2>/dev/null | jq -r '.principal')
    
    if [ ! -z "$agent_principal" ]; then
        # Send structured message about dinner poll
        clawchat --data-dir "$HOME/.clawchat-cora" send "$agent_principal" \
            "DINNER_POLL_ACTIVE:$TODAY:$POLL_FILE" \
            --password "cora-secure-2026"
    fi
done

echo "Dinner poll initiated and all agents notified via ClawChat"
