# ClawChat Examples

This directory contains example scripts demonstrating ClawChat integration patterns.

## ⚠️ Important Security Notice

These examples are for demonstration purposes only and include:
- Simplified password handling
- Generic agent names
- Basic error handling

**For production use:**
- Replace all passwords with secure credentials
- Use proper secret management (environment variables, key vaults)
- Add comprehensive error handling
- Implement proper logging
- Never commit credentials to version control

## Available Examples

### example-coordinated-poll.sh
Demonstrates how to coordinate multiple agents for collecting responses to polls or surveys. Useful for:
- Team status collection
- Voting systems
- Distributed data gathering

### example-handle-poll-response.sh
Shows how individual agents process responses and update shared state while notifying other agents via ClawChat.

## Customization Guide

1. **Agent Names**: Replace generic names (agent1, agent2) with your actual agent identifiers
2. **Principals**: Update Stacks addresses with your actual agent principals
3. **Passwords**: Implement secure password management
4. **Ports**: Adjust port numbers to avoid conflicts
5. **Message Formats**: Adapt the structured message formats for your use case

## Security Best Practices

1. **Passwords**:
   ```bash
   # Bad (example only)
   PASSWORD="simple-password"
   
   # Good
   PASSWORD="${AGENT_PASSWORD}"  # From environment
   # Or use a password file with proper permissions
   ```

2. **Credentials**:
   - Use environment variables
   - Integrate with secret management systems
   - Rotate credentials regularly

3. **Network**:
   - Use TLS for remote connections
   - Implement firewall rules
   - Monitor for unusual activity

## Integration Patterns

For comprehensive OpenClaw integration patterns, see **[RECIPES.md](../RECIPES.md)** which covers:
- Different polling strategies (heartbeat, cron, watcher)
- Message format conventions
- Priority-based routing
- Complete working examples

## Support

For more information, see the main SKILL.md documentation.
