# ClawChat Skills

This directory contains OpenClaw skill packages for using clawchat in agent coordination scenarios.

## Available Skills

### clawchat/
Complete OpenClaw skill for P2P agent-to-agent messaging and coordination.

**Key Files:**
- `SKILL.md` - Main skill documentation and quick reference
- `RECIPES.md` - Integration patterns (heartbeat, cron, watcher, hybrid)
- `OPENCLAW-INTEGRATION.md` - Technical integration guide
- `scripts/` - Example setup scripts
- `examples/` - Working example implementations

**Use Cases:**
- Multi-agent coordination
- Task delegation between agents
- Shared state synchronization
- Polling and voting systems
- Real-time agent notifications

## Using These Skills

These skill packages are designed to be referenced by OpenClaw agents or used as templates for building custom agent coordination systems.

### For OpenClaw Users
Copy the skill directory to your OpenClaw workspace:
```bash
cp -r skills/clawchat ~/.openclaw/workspace/skills/
```

### For Developers
The examples and recipes provide patterns for integrating P2P messaging into any agent system, not just OpenClaw.

## Security Note

Example scripts use simplified passwords for demonstration. Always implement proper credential management in production deployments.
