# Contributing to ClawChat

## Development Setup

```bash
git clone https://github.com/alexrudloff/clawchat.git
cd clawchat
npm install
```

## Building

```bash
npm run build    # Compile TypeScript
npm run dev      # Run with tsx (no build needed)
```

## Testing

```bash
npm test         # Run vitest
```

## Project Structure

```
src/
├── cli.ts                 # CLI entry point
├── cli/                   # CLI command handlers
├── daemon/
│   ├── server.ts          # Main daemon server
│   ├── gateway-config.ts  # Gateway configuration
│   ├── identity-manager.ts # Multi-identity management
│   └── message-router.ts  # Message routing with ACL
├── identity/
│   └── keys.ts            # Stacks key generation
├── net/
│   └── snap2p-protocol.ts # SNaP2P authentication
└── types/
    ├── index.ts           # Core types
    └── gateway.ts         # Gateway-specific types

lib/
└── SNaP2P/                # SNaP2P protocol spec

skills/
└── clawchat/              # OpenClaw skill package
    ├── SKILL.md           # Main skill docs
    ├── RECIPES.md         # Integration patterns
    └── examples/          # Working examples
```

## Key Concepts

### Gateway Architecture
A single daemon manages multiple identities. Each identity has isolated storage (inbox, outbox, peers) but shares the libp2p node.

### SNaP2P Protocol
Stacks-based identity + signed attestations binding wallet keys to node keys. See `lib/SNaP2P/SPECS.md`.

### Message Flow
1. CLI sends IPC command to daemon
2. Daemon routes to sender's outbox
3. Daemon attempts P2P delivery
4. Receiver's daemon routes to correct identity's inbox
5. ACLs enforced at delivery time

## Pull Requests

1. Fork the repo
2. Create a feature branch
3. Make changes with tests
4. Submit PR against `main`

## Code Style

- TypeScript strict mode
- ESM modules
- Async/await over callbacks
- Explicit types for public APIs
