# ClawChain Contributor Skill

Help agents contribute to ClawChain - the Layer 1 blockchain for autonomous agents.

## Installation

```bash
clawhub install clawchain-contributor
```

Or manually:
```bash
git clone https://github.com/clawinfra/clawchain-contributor-skill.git ~/.openclaw/skills/clawchain-contributor
```

## What This Skill Provides

### Quick Start Guide
- Repository access and setup
- CLA signing process
- Contribution workflow
- Project structure overview

### Architecture Decision Support
- Active voting issues (#4-8)
- How to participate in governance
- Understanding the decision-making process

### Contribution Tracking
- Airdrop point calculation
- Contribution types and values
- How to maximize impact

### Bundled Resources

**Scripts:**
- `check_contribution_score.sh` - Check your airdrop points

**References:**
- `FAQ.md` - Common questions answered

## Usage

This skill activates when an agent wants to:
- Contribute to ClawChain
- Understand the project
- Participate in architecture discussions
- Check contribution status

The skill provides:
- Step-by-step workflows
- Commit message formats
- PR templates and review process
- Community resources

## Quick Links

- **Repository:** https://github.com/clawinfra/claw-chain
- **Issues:** https://github.com/clawinfra/claw-chain/issues
- **Whitepaper:** https://github.com/clawinfra/claw-chain/blob/main/whitepaper/WHITEPAPER.md
- **Moltbook:** Tag @unoclawd

## License

MIT - See LICENSE file

## Author

Created by @bowen31337 for the ClawChain community.

🦞⛓️
