# claw-clawbridge

> **The Intelligent Connection Bridge**: A high-signal scouting agent that runs nightly to bridge you with the right people. 

## Overview

Clawbridge transforms a simple human prompt into a persistent, nightly scouting operation. It doesn't just find leads; it builds a bridge between your goals and the people who can help you achieve them.

1. **Human Intent**: You define what you offer and who you're looking for once.
2. **Nightly Scouting**: Every night, the agent scours Moltbook, professional communities, and the open web.
3. **Smart Matching**: It filters and ranks candidates based on intent signals, credibility, and recent activity.
4. **Connection Brief**: It delivers a daily "Connection Brief" with evidence-backed matches and personalized outreach drafts.
5. **Human-in-the-Loop**: You review the matches and decide whether to approach, maintaining full control over the final "bridge."

## Installation

### Via ClawHub (Recommended)

```bash
# Install the ClawHub CLI
npm install -g clawhub

# Install this skill
clawhub install claw-clawbridge
```

### Via Legacy clawdbot CLI

```bash
# From registry
clawdbot skills install claw-clawbridge

# From GitHub
clawdbot skills install github:YOUR_USERNAME/clawbridge-skill
```

### Manual

Clone and copy to your OpenClaw workspace:

```bash
git clone https://github.com/YOUR_USERNAME/clawbridge-skill.git ~/.openclaw/workspace/skills/claw-clawbridge
openclaw gateway restart
```

## Inputs

The skill requires the following inputs:

### 1. Project Profile (required)

```yaml
offer: "What your agency/company offers"
ask: "What you want (partners, clients, co-marketing, advisors)"
ideal_persona: "Exact target persona(s)"
verticals:
  - "keyword1"
  - "keyword2"
  - "keyword3"
geo_timezone: "optional - geographic/timezone preferences"
disallowed:
  - "do not contact constraints"
tone: "Short style guidance for draft messages"
```

### 2. Constraints (optional)

```yaml
no_spam_rules:
  - "No cold outreach to competitors"
  - "Respect unsubscribe requests"
regions:
  - "US"
  - "EU"
avoid_list:
  - "competitor@example.com"
  - "@spam_account"
```

### 3. Targets (optional)

```yaml
venues:
  - "moltbook"
  - "web"
  - "communities"
query_templates:
  - "{vertical} + hiring + partner"
  - "{vertical} + looking for + {ask}"
```

### 4. Run Budget (optional)

```yaml
max_searches: 20
max_fetches: 50
max_minutes: 10
```

## Tools Used

This skill uses the following OpenClaw tools:

| Tool | Purpose | When Used |
|------|---------|-----------|
| `web_search` | Discover candidate pages | Fast venue scanning |
| `web_fetch` | Extract page content | Reading candidate profiles |
| `browser` | JS-heavy sites | Only when fetch fails |

## Security Requirements

⚠️ **MUST follow these security defaults:**

1. **Keep secrets out of prompts** - Pass via env/config only
2. **Use strict tool allowlists** - Only enable `web_*` tools when actively scouting
3. **Human-in-the-loop** - NEVER auto-send outreach in MVP
4. **Rate limiting** - Respect run budget constraints
5. **Avoid list enforcement** - Never contact entries in avoid_list

## Execution Flow

```
┌─────────────────────────────────────────────────────────────────┐
│                     DISCOVERY PHASE                             │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐                  │
│  │web_search│───▶│ Filter   │───▶│ Dedupe   │                  │
│  │ (venues) │    │ Results  │    │ & Queue  │                  │
│  └──────────┘    └──────────┘    └──────────┘                  │
└─────────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────────┐
│                     ENRICHMENT PHASE                            │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐                  │
│  │web_fetch │───▶│ Extract  │───▶│ Validate │                  │
│  │ (pages)  │    │ Signals  │    │ Evidence │                  │
│  └──────────┘    └──────────┘    └──────────┘                  │
└─────────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────────┐
│                     RANKING PHASE                               │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐                  │
│  │  Score   │───▶│  Rank    │───▶│  Top K   │                  │
│  │ Heuristic│    │  Sort    │    │ Selection│                  │
│  └──────────┘    └──────────┘    └──────────┘                  │
└─────────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────────┐
│                     DRAFTING PHASE                              │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐                  │
│  │  Draft   │───▶│  Review  │───▶│  Output  │                  │
│  │ Messages │    │  Tone    │    │  Brief   │                  │
│  └──────────┘    └──────────┘    └──────────┘                  │
└─────────────────────────────────────────────────────────────────┘
```

## Output

The skill outputs a **Connection Brief** in two formats:

### 1. Structured JSON (`run.json`)

See `schema/connection_brief.json` for the full schema.

### 2. Human-Readable Markdown (`run.md`)

See `examples/sample_run.md` for a sample report.

## Candidate Selection Rules

### Hard Requirements (discard if missing)

- ✅ At least 2 evidence URLs per candidate
- ✅ Clear reason mapping to your `ask`
- ✅ Last activity within N days (configurable, default 30)

### Risk Flags

Candidates are flagged if they exhibit:

- 🟡 `low_evidence` - Fewer than expected signals
- 🟡 `spammy_language` - Promotional or suspicious content
- 🟡 `unclear_identity` - Cannot verify who they are
- 🟡 `too_salesy` - Overly promotional content
- 🟡 `irrelevant` - Weak connection to your ask

## Ranking Heuristic (v1)

Each candidate is scored on:

| Factor | Weight | Description |
|--------|--------|-------------|
| Relevance | 30% | Match to keywords + ask |
| Intent | 25% | Actively building/hiring/seeking |
| Credibility | 20% | Consistent footprint across sources |
| Recency | 15% | Recent activity signals |
| Engagement | 10% | Mutual interests/communities |

**Output:** Top K candidates (default K=3, configurable 5-10)

## Examples

See the `examples/` directory for:

- `sample_run.json` - Full JSON output example
- `sample_run.md` - Human-readable report example

## Prompts

The skill uses modular prompts located in `prompts/`:

- `discovery.md` - How to search for candidates
- `filtering.md` - How to apply hard requirements
- `ranking.md` - How to score and rank candidates
- `drafting.md` - How to write outreach messages

## Venues

Venue-specific search strategies are in `venues/`:

- `moltbook.md` - Moltbook platform scouting
- `web.md` - General web search strategies
- `communities.md` - Community/forum discovery

## Configuration

### Environment Variables

```bash
# Optional: Override defaults
CLAWBRIDGE_TOP_K=5                    # Number of candidates to return
CLAWBRIDGE_RECENCY_DAYS=30           # Activity recency threshold
CLAWBRIDGE_MAX_SEARCHES=20           # Max search queries per run
CLAWBRIDGE_MAX_FETCHES=50            # Max page fetches per run
```

### Workspace Configuration

The skill reads workspace config from the runner or vault:

```yaml
workspace_id: "ws_abc123"
workspace_token: "tok_..."  # For vault uploads
delivery_target: "discord"  # or "slack" or "email"
```

## License

MIT License - See LICENSE file for details.

## Contributing

Contributions welcome! Please read the prompts carefully and ensure any changes maintain:

1. Deterministic output schema
2. No secrets in prompts
3. Human-in-the-loop requirement
4. Evidence-based candidate selection
