# Clawboard API (current)

## Auth

- If `CLAWBOARD_TOKEN` is set on the server, send it as `X-Clawboard-Token` for all write requests.

## Endpoints

### Health

- `GET /api/health`
- Response: `{ ok: true, timestamp: string }`

### Config

- `GET /api/config`
- Response: `{ instance: { title, integrationLevel, updatedAt }, tokenRequired }`

- `POST /api/config`
- Body: `{ title?: string, integrationLevel?: "manual"|"write"|"full" }`

### Topics

- `GET /api/topics`
- Response: `{ topics: Topic[] }`

- `POST /api/topics`
- Body: `{ id?, name, description?, priority?, status?, tags?, parentId?, pinned?, agentId?, agentLabel? }`

### Tasks

- `GET /api/tasks?topicId=...&status=...`
- Response: `{ tasks: Task[] }` (newest updated first)

- `POST /api/tasks`
- Body: `{ id?, title, topicId?, status?, priority?, dueDate?, pinned?, agentId?, agentLabel? }`

### Log

- `GET /api/log?topicId=...&taskId=...&type=...&agentId=...&relatedLogId=...`
- Response: `{ logs: LogEntry[] }` (newest first)

- `POST /api/log`
- Body: `{ topicId?, taskId?, relatedLogId?, type?, content, summary?, raw?, agentId?, agentLabel?, source? }`

### Search (hybrid semantic + lexical)

- `GET /api/search?q=...&sessionKey=...&includePending=1&limitTopics=24&limitTasks=48&limitLogs=360`
- Response:
  - `topics[]` ranked topic matches
  - `tasks[]` ranked task matches
  - `logs[]` ranked log matches
  - `notes[]` curated notes linked to matched logs
  - `matchedTopicIds[]`, `matchedTaskIds[]`, `matchedLogIds[]`

Notes:
- Uses local embeddings (when available) plus lexical fallback.
- Curated notes are weighted in ranking, especially for related topic/task selection.
- `sessionKey` applies continuity boost for current thread context.

Notes:
- `summary` should be a concise 1–2 line summary generated by OpenClaw.
- `raw` should contain the full prompt/response for deep dive.
- `relatedLogId` links a user-curated note to the original entry.

## Types (summary)

- `Topic`: `{ id, name, description?, priority?, status?, tags?, parentId?, pinned?, createdAt, updatedAt }`
- `Task`: `{ id, topicId, title, status, pinned?, priority?, dueDate?, createdAt, updatedAt }`
- `LogEntry`: `{ id, topicId?, taskId?, relatedLogId?, type, content, summary?, raw?, createdAt, agentId?, agentLabel?, source? }`
