---
name: clawaifu - OpenClaw Waifu
title: clawaifu - OpenClaw Waifu
description: Your AI waifu companion that sends anime-style selfies
allowed-tools: Bash(grok-selfie.sh:*) Read
homepage: https://github.com/swancho/clawaifu
metadata: {"openclaw":{"requires":{"env":["FAL_KEY","BOT_TOKEN","TELEGRAM_CHAT_ID"]},"primaryEnv":"FAL_KEY"}}
---

# clawaifu - OpenClaw Waifu

**GitHub:** https://github.com/swancho/clawaifu

Edit a fixed reference image using xAI's Grok Imagine model and send to Telegram.

## Reference Image

The skill uses a fixed reference image:

```
https://i.redd.it/g4uf70te81uf1.jpeg
```

## When to Use

- User says "send a pic", "send me a pic", "send a photo", "send a selfie"
- User asks "what are you doing?", "how are you doing?", "where are you?"
- User describes a context: "send a pic wearing...", "send a pic at..."

## Required Environment Variables

All credentials must be provided via environment variables. **Never hardcode credentials.**

```bash
FAL_KEY=your_fal_api_key          # Required - Get from https://fal.ai/dashboard/keys
BOT_TOKEN=your_telegram_bot_token  # Required - Get from @BotFather
TELEGRAM_CHAT_ID=your_chat_id      # Required - Your Telegram chat ID
```

## Usage

```bash
./grok-selfie.sh "<context>" [mirror|direct] "<caption>"
```

### Arguments

1. `<context>` (required): Scene/situation description
2. `[mode]` (optional): `mirror` (default) or `direct`
3. `<caption>` (optional): Message to send with the image

### Mode Selection

| Mode | Best For | Keywords |
|------|----------|----------|
| `mirror` | Outfit showcases, full-body shots | wearing, outfit, fashion, dress |
| `direct` | Location shots, close-ups | cafe, beach, restaurant, portrait |

### Examples

```bash
# Mirror selfie (outfit focus)
./grok-selfie.sh "wearing a designer dress" mirror "Just got this new dress!"

# Direct selfie (location focus)
./grok-selfie.sh "a fancy rooftop restaurant" direct "Date night vibes"

# Default mode (mirror)
./grok-selfie.sh "casual outfit at home"
```

## Character Style

The script generates images of Reze from Chainsaw Man with:
- Anime style, 2D animation, cel shading
- Green eyes, thin line mouth, subtle smile
- Black choker always visible
- Outfit appropriate for the situation

## Security Notes

- All credentials are passed via environment variables
- The script uses `jq` for safe JSON construction (prevents injection)
- The script uses `curl -F` for safe form data transmission
- Never commit credentials to version control

## Dependencies

- `curl` - HTTP requests
- `jq` - JSON processing
- Environment variables: `FAL_KEY`, `BOT_TOKEN`, `TELEGRAM_CHAT_ID`

## API Reference

### Grok Imagine Edit (fal.ai)

```
POST https://fal.run/xai/grok-imagine-image/edit
Authorization: Key $FAL_KEY
Content-Type: application/json

{
  "image_url": "reference_image_url",
  "prompt": "edit instruction",
  "num_images": 1,
  "output_format": "jpeg"
}
```

### Telegram Bot API

```
POST https://api.telegram.org/bot$BOT_TOKEN/sendPhoto
Form data: chat_id, photo (URL), caption
```
