#!/bin/bash
# 任务日志统计脚本
# 分析任务执行情况，生成统计报告

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SKILL_DIR="$(dirname "$SCRIPT_DIR")"
TASK_LOG="$SKILL_DIR/memory/tasks-log.md"

echo "=== 任务日志统计 ==="
echo "统计时间: $(date '+%Y-%m-%d %H:%M:%S')"
echo ""

if [ ! -f "$TASK_LOG" ]; then
    echo "❌ 任务日志文件不存在"
    exit 1
fi

# 总任务数
TOTAL=$(grep -c "✅ TASK-" "$TASK_LOG" 2>/dev/null || echo "0")
echo "📊 总完成任务数: $TOTAL"

# 按日期统计
echo ""
echo "📅 按日期统计:"
grep "✅ TASK-" "$TASK_LOG" | grep -oE "\([0-9]{4}-[0-9]{2}-[0-9]{2}\)" | sort | uniq -c | sort -rn

# 产出类型统计
echo ""
echo "📁 产出类型统计:"
echo "  研究报告: $(grep -c "research/" "$TASK_LOG" || echo 0)"
echo "  文档草稿: $(grep -c "drafts/" "$TASK_LOG" || echo 0)"
echo "  应用代码: $(grep -c "apps/" "$TASK_LOG" || echo 0)"
echo "  脚本工具: $(grep -c "scripts/" "$TASK_LOG" || echo 0)"

# 最近任务
echo ""
echo "🕐 最近 5 个任务:"
grep "✅ TASK-" "$TASK_LOG" | tail -5

# 执行频率
echo ""
echo "📈 执行频率:"
DAYS=$(grep "✅ TASK-" "$TASK_LOG" | grep -oE "2026-03-[0-9]+" | sort -u | wc -l)
if [ "$DAYS" -gt 0 ]; then
    AVG=$((TOTAL / DAYS))
    echo "  执行天数: $DAYS 天"
    echo "  日均任务: $AVG 个"
fi

# 预计完成时间
echo ""
echo "⏱️  进度预估:"
REMAINING=$((65 - TOTAL))  # 假设 v2.0.0 需要约 65 个任务
if [ "$REMAINING" -gt 0 ]; then
    echo "  剩余任务: $REMAINING 个"
    if [ "$DAYS" -gt 0 ]; then
        DAYS_LEFT=$((REMAINING / AVG))
        echo "  预计还需: 约 $DAYS_LEFT 天"
    fi
fi

echo ""
echo "=== 统计完成 ==="
