#!/bin/bash

# Autonomous Tasks 诊断脚本
# 用法: ./diagnose.sh

set -e

echo "========================================"
echo "Autonomous Tasks 系统诊断"
echo "========================================"
echo ""

# 1. 检查 OpenClaw Gateway 状态
echo "1. 检查 OpenClaw Gateway 状态..."
if openclaw gateway status > /dev/null 2>&1; then
    echo "   ✅ Gateway 运行中"
else
    echo "   ❌ Gateway 未运行"
    echo "   → 运行: openclaw gateway start"
fi
echo ""

# 2. 检查 cron 任务
echo "2. 检查 Cron 任务..."
CRON_COUNT=$(openclaw cron list 2>/dev/null | grep -c "autonomous-tasks" || echo "0")
if [ "$CRON_COUNT" -gt "0" ]; then
    echo "   ✅ Cron 任务已配置 ($CRON_COUNT 个)"
else
    echo "   ❌ 未找到 autonomous-tasks cron 任务"
    echo "   → 运行: openclaw cron add --name 'autonomous-tasks' --every 1h"
fi
echo ""

# 3. 检查必要文件
echo "3. 检查必要文件..."
FILES=(
    "AUTONOMOUS.md"
    "memory/tasks-log.md"
    "memory/backlog.md"
    "SKILL.md"
)

for file in "${FILES[@]}"; do
    if [ -f "claw_self/$file" ]; then
        echo "   ✅ $file 存在"
    else
        echo "   ❌ $file 不存在"
    fi
done
echo ""

# 4. 检查目录结构
echo "4. 检查目录结构..."
DIRS=(
    "claw_self/research"
    "claw_self/drafts"
    "claw_self/apps"
    "claw_self/scripts"
    "claw_self/memory"
)

for dir in "${DIRS[@]}"; do
    if [ -d "$dir" ]; then
        FILE_COUNT=$(find "$dir" -type f 2>/dev/null | wc -l)
        echo "   ✅ $dir ($FILE_COUNT 个文件)"
    else
        echo "   ❌ $dir 不存在"
    fi
done
echo ""

# 5. 统计任务完成情况
echo "5. 任务完成统计..."
if [ -f "claw_self/memory/tasks-log.md" ]; then
    TOTAL=$(grep -c "✅" claw_self/memory/tasks-log.md || echo "0")
    echo "   已完成任务: $TOTAL 个"
fi
echo ""

# 6. 检查最近执行
echo "6. 最近执行记录..."
if [ -f "claw_self/AUTONOMOUS.md" ]; then
    LAST_RUN=$(grep -A 3 "## 历史反思" claw_self/AUTONOMOUS.md | head -5)
    if [ -n "$LAST_RUN" ]; then
        echo "$LAST_RUN"
    else
        echo "   无执行记录"
    fi
fi
echo ""

echo "========================================"
echo "诊断完成"
echo "========================================"
