# 单元测试方案

本文档为 autonomous-tasks skill 设计测试覆盖方案。

## 测试目标

确保 autonomous-tasks skill 的核心功能稳定可靠，包括：
- 工作流正确执行
- 边界情况处理
- 状态追踪准确

## 测试类型

### 1. 单元测试

测试单个函数或模块的正确性：

| 模块 | 测试内容 | 优先级 |
|------|----------|--------|
| 目标读取 | AUTONOMOUS.md 解析 | 高 |
| 任务生成 | 任务 ID 递增逻辑 | 高 |
| 日志记录 | append-only 行为 | 高 |
| 文件操作 | 创建/读取/更新 | 中 |

### 2. 集成测试

测试多个模块的协作：

| 场景 | 测试内容 |
|------|----------|
| 完整工作流 | 读取目标 → 生成任务 → 执行 → 记录 → 反思 |
| Cron 触发 | cron 消息 → skill 触发 → 任务执行 |
| 边界情况 | 空目标、空 backlog、文件缺失 |

### 3. 端到端测试

模拟真实使用场景：

- 首次安装后的完整流程
- 连续多次执行的稳定性
- 跨文件状态一致性

## 测试框架建议

```
推荐工具：
- 单元测试: vitest / jest
- 集成测试: openclaw test
- E2E: playwright
```

## 测试用例示例

### 任务 ID 递增测试

```javascript
// 测试 tasks-log.md 中 TASK ID 正确递增
test('task ID increments correctly', () => {
  const log = readTasksLog();
  const lastId = parseInt(log.slice(-1).match(/TASK-(\d+)/)[1]);
  expect(generateNextId()).toBe(lastId + 1);
});
```

### 空目标处理测试

```javascript
// 测试空 AUTONOMOUS.md 时的行为
test('handles empty autonomous.md', () => {
  const goal = parseAutonomous('');
  expect(goal).toHaveProperty('longTermGoal');
  expect(goal.currentPhase).toBeDefined();
});
```

## 测试覆盖率目标

| 指标 | 目标 |
|------|------|
| 单元测试覆盖率 | 80%+ |
| 关键路径覆盖率 | 100% |
| 边界情况覆盖 | 90%+ |

## 执行计划

1. **第一周**: 选择测试框架，搭建测试环境
2. **第二周**: 实现核心单元测试
3. **第三周**: 添加集成测试
4. **持续**: 每次功能变更后补充测试

## 后续改进

- 引入 CI/CD 自动化测试
- 添加性能基准测试
- 实现回归测试套件

---

*本文档由 autonomous-tasks 自动生成 (2026-03-04)*
