# 故障排查指南

本文档帮助用户诊断和解决 autonomous-tasks skill 使用中的常见问题。

## 目录

1. [常见问题与解决方案](#常见问题与解决方案)
2. [日志分析](#日志分析)
3. [调试技巧](#调试技巧)

---

## 常见问题与解决方案

### Cron 触发问题

#### 问题：Cron 不触发

**症状**: 定时任务没有按预期执行

**排查步骤**:
1. 检查 cron 配置是否正确
   ```bash
   openclaw cron list
   ```
2. 确认 OpenClaw Gateway 正在运行
   ```bash
   openclaw gateway status
   ```
3. 查看系统日志
   ```bash
   tail -f /var/log/syslog | grep openclaw
   ```

**解决方案**:
- 重启 Gateway: `openclaw gateway restart`
- 重新添加 cron: `openclaw cron add --name "autonomous-tasks" --every 1h`

#### 问题：触发但无响应

**症状**: cron 触发了但任务没有实际执行

**排查步骤**:
1. 检查 AUTONOMOUS.md 是否存在且格式正确
2. 确认 skill 目录结构完整
3. 查看错误日志

---

### 文件读取问题

#### 问题：找不到 AUTONOMOUS.md

**症状**: 提示文件不存在

**排查步骤**:
1. 确认文件路径是否正确（应在 claw_self/AUTONOMOUS.md）
2. 检查文件权限

**解决方案**:
- 创建默认目标文件（参考 SKILL.md 模板）

#### 问题：目标为空

**症状**: SKILL.md 读取到空目标

**解决方案**:
1. 编辑 AUTONOMOUS.md 添加具体目标
2. 或从 backlog.md 提取待办任务

---

### 执行问题

#### 问题：任务执行超时

**症状**: 任务长时间未完成

**解决方案**:
- 增加 cron timeout: `--timeout-seconds 3600`
- 将大任务拆分为小任务

#### 问题：任务产出丢失

**症状**: 任务执行了但没有产出文件

**排查步骤**:
1. 检查产出目录是否存在
2. 确认任务写入权限
3. 查看 tasks-log.md 记录

---

### 权限问题

#### 问题：无文件写入权限

**症状**: 提示权限拒绝

**解决方案**:
```bash
chmod -R 755 ~/.openclaw/workspace/claw_self/
```

---

## 日志分析

### 查看执行日志

1. **tasks-log.md**: 查看已完成任务记录
2. **memory/**: 检查每日执行记录
3. **AUTONOMOUS.md**: 查看历史反思

### 常见错误码

| 错误码 | 含义 | 解决方案 |
|--------|------|----------|
| ENOENT | 文件不存在 | 检查文件路径 |
| EACCES | 权限不足 | 修改文件权限 |
| ETIMEDOUT | 执行超时 | 增加 timeout |
| EINVAL | 参数无效 | 检查配置 |

---

## 调试技巧

### 1. 手动触发测试

```bash
openclaw agent --message "执行自主任务"
```

### 2. 增量执行

每次只执行一个任务，方便定位问题：
- 修改 SKILL.md 中的任务生成数量（改为 1-2 个）

### 3. 检查 skill 状态

```bash
# 查看 cron 任务
openclaw cron list

# 查看 skill 安装状态
ls -la ~/.openclaw/workspace/skills/autonomous-tasks/
```

### 4. 隔离问题

如果某个任务失败：
1. 将其从 AUTONOMOUS.md 移除
2. 单独执行其他任务
3. 逐步排查

---

## 获取帮助

如果以上方案无法解决问题：

1. 收集以下信息：
   - 错误信息完整截图
   - 执行日志 (`tasks-log.md`)
   - 系统环境 (`openclaw status`)

2. 通过以下渠道反馈：
   - GitHub Issue: https://github.com/openclaw/openclaw/issues
   - Discord: https://discord.com/invite/clawd

---

*本文档由 autonomous-tasks skill 自动维护*
