# 用户反馈追踪机制

用于系统化收集、分类和追踪 autonomous-tasks skill 的用户反馈。

## 反馈来源

| 来源 | 追踪方式 | 优先级 |
|------|----------|--------|
| GitHub Issues | 标签 + Projects | 高 |
| Discord | 频道消息 + 主题 | 中 |
| 直接反馈 | 手动记录 | 中 |
| 内部测试 | 测试报告 | 高 |

## 反馈分类

### 类型定义

| 类型 | 描述 | 标签 |
|------|------|------|
| 🐛 Bug | 功能异常或错误 | `bug` |
| 💡 Feature | 新功能建议 | `feature` |
| 📖 Docs | 文档改进 | `documentation` |
| 👍 Feedback | 体验反馈 | `feedback` |
| ❓ Question | 问题咨询 | `question` |

### 优先级定义

| 优先级 | 描述 | 触发条件 |
|--------|------|----------|
| P0 | 紧急 | 影响核心功能使用 |
| P1 | 高 | 重要功能受损 |
| P2 | 中 | 功能可以凑合使用 |
| P3 | 低 | 锦上添花 |

## 追踪模板

### 反馈记录表

| 日期 | 来源 | 类型 | 描述 | 优先级 | 状态 | 处理人 |
|------|------|------|------|--------|------|--------|
|      |      |      |      |        |      |        |

### 状态流转

```
新提交 → 分类 → 评估 → 处理中 → 已解决 → 已发布
  ↓
  └── 拒绝（说明原因）
```

## 收集流程

### GitHub Issue 流程

1. 用户提交 Issue
2. 使用 `feedback` 标签标记
3. 每周汇总到本文件
4. 评估后分配优先级
5. 纳入版本规划

### Discord 反馈流程

1. 在反馈频道收集消息
2. 每月整理到反馈表
3. 高频问题转为 Issue

## 分析维度

### 定量指标

- 反馈数量（每月）
- 反馈类型分布
- 平均响应时间
- 解决率

### 定性指标

- 用户满意度趋势
- 痛点分析
- 功能需求优先级

## 反馈处理周期

| 类型 | 响应时间 | 解决周期 |
|------|----------|----------|
| Bug | 24h | 1 周 |
| Feature | 3 天 | 1 个月 |
| Docs | 1 周 | 2 周 |
| Question | 3 天 | N/A |

## 改进追踪

每次根据反馈优化后，记录：

```markdown
### YYYY-MM-DD 改进记录
- 反馈来源: GitHub Issue #XXX
- 问题类型: Bug
- 解决方案: 描述
- 影响版本: vX.Y.Z
```

---

*本文档由 autonomous-tasks 自动生成*
