# 读书计划场景示例

本文档展示如何使用 autonomous-tasks skill 来实现自主读书管理。

## 目标设置

在 AUTONOMOUS.md 中设置长期目标：

```markdown
# 我的目标

## 长期目标

在一年内精读 24 本技术书籍，构建完整的知识体系。

## 里程碑

- [ ] v1.0.0 — 完成前端基础系列 (4本)
- [ ] v1.1.0 — 完成前端进阶系列 (4本)
- [ ] v1.2.0 — 完成工程化系列 (4本)
- [ ] v1.3.0 — 完成架构与模式系列 (4本)
- [ ] v1.4.0 — 完成前沿技术系列 (4本)
- [ ] v1.5.0 — 完成综合实战系列 (4本)

## 当前阶段：前端基础系列

### 当前待改进项

- [ ] 每周阅读 1 章
- [ ] 每章做读书笔记
- [ ] 实践书中代码示例
```

## 自主任务示例

### 任务 1: 制定阅读计划

- 目标：设计系统化的读书计划，按主题和难度排序
- 产出：`drafts/reading-schedule.md`

### 任务 2: 创建读书笔记模板

- 目标：设计结构化的读书笔记格式
- 产出：`drafts/note-template.md`

### 任务 3: 收集技术书籍资源

- 目标：整理推荐的技术书籍清单和资源链接
- 产出：`research/tech-books-resources.md`

### 任务 4: 建立知识回顾机制

- 目标：设计定期回顾已读内容的机制
- 产出：`drafts/review-mechanism.md`

## 读书笔记模板

```markdown
# {书名}

## 基本信息
- 作者: {作者名}
- 页数: {页数}
- 阅读时间: {开始} - {结束}

## 核心概念

### 概念 1
- 理解: 
- 实践:

### 概念 2
- 理解:
- 实践:

## 实践项目

## 总结与感想
```

## 执行日志示例

```
- ✅ TASK-041: 制定阅读计划 → drafts/reading-schedule.md (2026-03-04)
- ✅ TASK-042: 创建读书笔记模板 → drafts/note-template.md (2026-03-04)
- ✅ TASK-043: 收集技术书籍资源 → research/tech-books-resources.md (2026-03-04)
```

## 效果追踪

每周回顾：
1. 本周读了哪些章节？
2. 掌握了哪些新概念？
3. 实践中遇到了什么问题？
4. 下周阅读计划是什么？

## 扩展场景

### 主题阅读模式

围绕一个主题阅读多本书：
- 周一至周三：书 A
- 周四至周五：书 B
- 周末：对比总结

### 深度阅读模式

一本好书读多遍：
- 第一遍：快速浏览（2小时）
- 第二遍：精读 + 笔记（8小时）
- 第三遍：实践 + 复习（4小时）

---

*示例创建时间: 2026-03-04*
