# Autonomous Tasks 快速上手指南

## 什么是 Autonomous Tasks？

Autonomous Tasks 是一个自驱动 AI 员工系统。通过定时触发或手动唤醒，它会自动读取目标、生成任务、执行产出、记录日志并反思改进。

## 5 分钟快速开始

### 第 1 步：安装

```bash
clawhub install autonomous-tasks
```

### 第 2 步：设置目标

编辑 `~/.openclaw/workspace/skills/autonomous-tasks/AUTONOMOUS.md`：

```markdown
# 我的目标

## 长期目标

（填写你的目标，例如：学习 Python 编程）

## 里程碑

- [ ] v1.0.0 — 完成基础学习
- [ ] v1.1.0 — 完成实战项目

## 当前阶段：起步

### 当前待改进项

- [ ] 暂无
```

### 第 3 步：设置定时触发

```bash
openclaw cron add \
  --name "autonomous-tasks" \
  --message "执行自主任务" \
  --every 1h
```

### 第 4 步：开始运行

AI 员工每小时会自动：
1. 读取你的目标
2. 生成具体任务
3. 执行并产出结果
4. 记录到日志
5. 反思改进

## 文件结构

```
autonomous-tasks/
├── AUTONOMOUS.md      # 你的目标
├── memory/
│   ├── tasks-log.md   # 完成任务日志
│   └── backlog.md     # 待办想法池
├── research/          # 调研产出
├── drafts/            # 文档产出
└── scripts/           # 脚本产出
```

## 常见问题

### Q: 如何手动触发？
A: 说"去干活"、"继续"或运行 `openclaw agent --message "执行自主任务"`

### Q: 任务产出在哪里？
A: 根据类型自动分类：research/, drafts/, apps/, scripts/

### Q: 如何查看完成的任务？
A: 查看 `memory/tasks-log.md`

### Q: 可以自定义触发频率吗？
A: 可以，修改 cron 的 `--every` 参数（如 `--every 2h`）

### Q: 如何暂停？
A: 运行 `openclaw cron delete --name "autonomous-tasks"`

## 进阶使用

### 添加任务想法

编辑 `memory/backlog.md`：

```markdown
## 待评估任务想法

- [ ] 学习 Python 基础语法
- [ ] 完成第一个小程序
```

### 手动添加任务到 AUTONOMOUS.md

在 "当前待改进项" 下添加：

```markdown
- [ ] 学习 Python 基础语法
```

---

*有问题？欢迎反馈：https://github.com/openclaw/openclaw/issues*
