# 个人知识管理系统场景示例

本文件展示如何使用 autonomous-tasks skill 管理"个人知识管理"目标。

## 目标设定

## 长期目标

建立完善的个人知识管理系统，实现知识的高效收集、整理、复用和创造。

## 里程碑

- [ ] v1.0.0 — 确定知识管理工具栈
- [ ] v1.1.0 — 建立知识分类体系
- [ ] v1.2.0 — 完成 100 条知识卡片
- [ ] v1.3.0 — 实现知识连接和复盘机制

## 当前阶段：工具选型

### 当前待改进项

- [ ] 调研主流知识管理工具
- [ ] 确定工具组合方案
- [ ] 设计分类体系

---

## 自主任务设置

### Cron 触发

```bash
openclaw cron add \
  --name "knowledge-management" \
  --message "继续优化知识管理系统" \
  --every 2d
```

### 任务生成策略

每次唤醒时：
1. 评估当前知识库状态
2. 生成收集/整理/连接任务
3. 记录知识增量

### 工具栈推荐

- **收集**: flomo、Notion、Cubox
- **整理**: Obsidian、Logseq
- **输出**: 博客、 newsletter

### 知识分类建议

1. **概念卡**: 核心概念定义
2. **方法卡**: 可复用的方法论
3. **案例卡**: 实际应用案例
4. **灵感卡**: 随机产生的想法
5. **反常识卡**: 与直觉相悖的知识

### 产出追踪

- 每周整理 10 条新知识卡片
- 每月进行一次知识连接复盘
- 每季度输出一篇知识总结文章
